;***************************************************************************
;
;   Filename: hostcpu.asm
;   Date:     91.04.10
;   Description: identifies host CPU
;   Returns:
;   Anything requiring clarification :
;   Modified:    
;
;***************************************************************************

        TITLE   cpu.asm
        NAME    cpu_id


.386P


CPUID_TEXT       SEGMENT  WORD PUBLIC 'CODE' USE16
CPUID_TEXT       ENDS
DATA             SEGMENT  WORD PUBLIC 'DATA' USE16
DATA             ENDS
_BSS             SEGMENT  WORD PUBLIC 'BSS' USE16
_BSS             ENDS
DGROUP           GROUP    _BSS, DATA
ASSUME  CS: CPUID_TEXT, DS: DGROUP, SS: DGROUP

        public   _cpuid

CPUID_TEXT    SEGMENT WORD PUBLIC 'CODE'

;       Conditional jumps are all coded with the SHORT qualifier in
;       order to minimize the size of the .OBJ file output of Turbo
;       Assembler.

;--------------------------------------------------------------------

;***************************************************************************
;
;   Function: _cpuid
;   Author: ?
;   Date:   ?
;   Parameters: 
;
;               BP
;       SP =>   near return address
;               offset  of a cpu_info_t record
;               segment "  "     "        "
;       also, the test type byte should be a 'C' or 'N' to execute the
;       CPU or NDP tests.
;
;   Description: identifies host CPU
;   Returns:
;
;       On exit, the cpu_info_t record has been filled in as follows:
;
;               byte    = CPU type
;               word    = Machine Status Word
;               6 bytes = Global Descriptor Table
;               6 bytes = Interrupt Descriptor Table
;               boolean = segment register change/interrupt flag
;               byte    = NDP type
;               word    = NDP control word
;               byte    = Weitek presence
;               byte    = test type (C, N, or W)
;
;   Anything requiring clarification :
;   Modified:    
;
;***************************************************************************


cpu_info        equ     [bp + 6]

mCPU    equ     byte ptr [bx]
mMSW    equ     word ptr [bx + 1]
mGDT    equ     [bx + 3]
mIDT    equ     [bx + 9]
mchkint equ     byte ptr [bx + 15]
mNDP    equ     byte ptr [bx + 16]
mNDPCW  equ     word ptr [bx + 17]
mWeitek equ     byte ptr [bx + 19]
mtest   equ     byte ptr [bx + 20]

f8088   equ     0
f8086   equ     1
fV20    equ     2
fV30    equ     3
f80188  equ     4
f80186  equ     5
f80286  equ     6
f80386  equ     7
f80486  equ     8
funk    =       0FFH

false   equ     0
true    equ     1

;***************************************************************************
_cpuid   proc    far

;  assume  cs:CPUID_TEXT, ds:DATA, es:DATA, ss:nothing

        push    bp		;

        mov     bp,sp

	push	si		; Registers si, di and bp are used by
	push	di		; Borland C++ they must be preserved.
        push    ds

	lds     bx,cpu_info
        call    cpu
				; Restore previously saved registers.
	pop     ds
	pop	di		;
	pop	si

	pop     bp		

        ret

_cpuid  endp

;--------------------------------------------------------------------

cpu     proc    near

; interrupt of multi-prefix string instruction

        mov     mCPU,funk               ;set CPU type to unknown
        sti
        push    es
        xor     cx, cx
        mov     es, cx
        mov     cx,0FFFFH
rep     lods    byte ptr es:[si]
        pop     es
        jcxz    short cpu_02
        call    piq
        cmp     dx,4
        jg      short cpu_01
        mov     mCPU,f8088
        jmp     short finito
cpu_01:
        cmp     dx,6
        jne     short cpu_01a
        mov     mCPU,f8086
cpu_01a:
        jmp     short finito
cpu_02:

; number of bits in displacement register used by shift

        mov     al,0FFH
        mov     cl,20H
        shl     al,cl
        or      al,al
        jnz     short cpu_04
        call    piq
        cmp     dx,4
        jg      short cpu_03
        mov     mCPU,fV20
        jmp     short finito
cpu_03:
        cmp     dx,6
        je      short cpu_03a
        jmp     short finito
cpu_03a:
        mov     mCPU,fV30
        jmp     short finito
cpu_04:

; order of write/decrement by PUSH SP

        push    sp
        pop     ax
        cmp     ax,sp
        je      short cpu_06
        call    piq
        cmp     dx,4
        jg      short cpu_05
        mov     mCPU,f80188
finito:
        jmp     short cpu_done
cpu_05:
        cmp     dx,6

        jne     short cpu_done

        mov     mCPU,f80186
        jmp     short cpu_done

; We most likely have a 286, 386 or 486 CPU by now
;First, grab some tables

cpu_06:
;!!!    smsw    mMSW  
;!!!    sgdt    mGDT  ; don't need this
;!!!    sidt    mIDT

; 
; Original 286/386 detection code (modified 8/10/90)
; Modified by code supplied by John Levine, apparantly from an Intel
; '486 manual.
; 

        pushf                           ;put flags into CX
        pop     cx
        and     cx,0fffh                ;mask off upper 4 bits
        push    cx
        popf
        pushf
        pop     ax
        and     ax,0f000h               ;look only at upper 4 bits
        cmp     ax,0f000h               ;88/86 etc.. turn them on
        jz      short badcpu            ;not 286/386/486
        or      cx,0f000h               ;force upper 4 bits on
        push    cx
        popf
        pushf
        pop     ax
        and     ax,0f000h
        jz      short found286          ;bits are zeroed in real mode 286
;
;since we probably have have a 386 or 486 by now, we need to do some 32-bit
;work. Detect the 486 by seeing if the Alignment Check flag is settable. This
;flag only exists on the '486.
;
;!!! .386
        and     esp,0FFFFh              ;use only 64K stack
        mov     edx,esp                 ;save current stack position
        and     esp,0FFFCh              ;dword align to avoid traps
        pushfd                          ;push 32 bit flag
        pop     eax
        mov     ecx,eax                 ;save current flags
        xor     eax,40000h              ;flip AC (alignment check) flag
        push    eax
        popfd
        pushfd
        pop     eax
        xor     eax,ecx                 ;eliminate all but AC bit
        push    ecx                     ;restore flags
        popfd
        mov     esp,edx                 ;restore stack position
        test    eax,40000h              ;is bit set?
;!!! .286
        jz      short found386          ;if not, is a 386
        mov     mCPU,f80486             ;must be a 486!!
        jmp     short cpu_done
found286:
        mov     mCPU,f80286
        jmp     short cpu_done
found386:
        mov     mCPU,f80386
        jmp     short cpu_done
badcpu:
        mov     mCPU,funk               ;how'd an 8088 get this far?????
cpu_done:
        ret
cpu     endp
;--------------------------------------------------------------------

piq     proc    near

;       On exit:
;
;               DX      = length of prefetch instruction queue
;
;       This subroutine uses self-modifying code, but can
;       nevertheless be run repeatedly in the course of the calling
;       program.

count   =       7
opincdx equ     42H                     ; inc dx opcode
opnop   equ     90H                     ; nop opcode

        mov     al,opincdx
        mov     cx,count
        push    cx
        push    cs
        pop     es
        mov     di,offset piq_01 - 1
        push    di
        std
        rep stosb
        mov     al,opnop
        pop     di
        pop     cx
        xor     dx,dx
        cli
        rep stosb
        rept    count
        inc     dx
        endm
piq_01:
        sti
        ret
piq     endp

;--------------------------------------------------------------------





CPUID_TEXT    ENDS

;--------------------------------------------------------------------

DATA    segment word

; storage for _cpuid

; redirected INT 01H vector

old_int01       label   dword
old_int01_ofs   dw      ?
old_int01_seg   dw      ?

; storage for NDPID

; 80x87 control word after initialization, status word after divide by zero

ndp_cw          dw      ?
ndp_sw          dw      ?

; storage for DISKREAD

; DOS 4.0 extended read parameter block
dos4_block                      label   byte
extd_starting_sector_lo         dw      ?
extd_starting_sector_hi         dw      ?
extd_number_of_sectors          dw      ?
extd_bufofs                     dw      ?
extd_bufseg                     dw      ?


DATA    ends

        end
