/*
    filename :  etag.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#if defined(I_UNIX)
#include <errno.h>
#endif

extern short  buff[];
extern short  *ptrbuff;

extern  I_IMGLOB    i_glob;

/*/     Function:   iosdetag()
*       Synopsis:   This routine puts an external sync command into the
*                   processing queue.
*
*       Date:       December 6, 1989.
*       parameters: short resource : #define constant identifying the
*                   resource to tag.
*                                               
*       returns:    --- NONE ---
*
**/


#ifdef  ANSI
void FTYPE iosdetag(short resource)
#else
FTYPE iosdetag(resource)
short resource;
#endif
{
    ptrbuff = buff;

    *ptrbuff++ = 0x01FE;
    *ptrbuff   = resource;

    ioputbuf( buff, 2 );

} /* iosdetag() */ 


/*/     Function:   iowtetag()
*       Synopsis:   This routine waits for an external tag to be returned
*                   from the resource identified by the argument
*
*       Date:       Le 6 decembre 1989.
*       parameters: short resource : #define constant identifying the
*                       tag to wait.
*                                               
*       returns:    --- NONE ---
**/

#ifdef  ANSI
void FTYPE iowtetag(short resource)
#else
FTYPE iowtetag(resource)
short resource;
#endif
{

#if defined(I_MS_DOS)

    unsigned short mask;
    unsigned short regval;

    /* build resource tag mask */
    mask = 1 << resource;

    /* loop while last interrupt remain unserviced */
    while (( i_glob.imghra->hstctll ) & I_INTIN );

    /* loop until tag arrives */
    while ((( i_glob.imghra -> dpyadr ) & mask ) == 0 );

    /* send message to identify received tag */
    i_glob.imghra -> dpystrt = mask;

    /* send interrupt to verify tag */
    /* this is required for compatibility with other programs */
    /* linked with previous versions of the etag routines */
    /* can be removed if not necessary. */
    /* optional compatibility block starts here */

    regval = i_glob.imghra->hstctll;

    /* set MSGIN field to zero */
    regval &= ~I_MSGINMSK;

    /* set INTIN and MSGIN */
    i_glob.imghra->hstctll = regval | I_INTIN | I_MSG_ETAG_VERIFY;

    /* loop while last interrupt remain unserviced */
    while (( i_glob.imghra->hstctll ) & I_INTIN );

    /* loop until tag arrives */
    while ((( i_glob.imghra -> dpyadr ) & mask ) == 0 );

    /* optional compatibility block ends here */

    /* send interrupt to GSP with etag_ack message */

    regval = i_glob.imghra->hstctll;

    /* set MSGIN field to zero */
    regval &= ~I_MSGINMSK;

    /* set INTIN and MSGIN */
    i_glob.imghra->hstctll = regval | I_INTIN | I_MSG_ETAG_ACK;

#endif

#ifdef I_OS2

unsigned short out_buf;

DosDevIOCtl(&resource,&out_buf,
            (unsigned short)I_WT_ETAG,
            (unsigned short)0x80,
            (HFILE)i_glob.board);


#endif

#ifdef  I_UNIX
    while ( ioctl ( i_glob.board, IMG_IOWTETAG , &resource ) == -1 )
        if ( errno != EINTR )
            return ;

#endif

} /* iowtetag() */ 

/*/     Function:   ioiqetag()
*       Synopsis:   This inquires destructively for an external tag to return.
*
*       Date:       Le 6 decembre 1989.
*       parameters: short resource : #define constant identifying the
*                   tag to inquire about.
*                                       
*       returns:    --- NONE ---
**/

#ifdef  ANSI
short FTYPE ioiqetag(short resource)

#else
short FTYPE ioiqetag(resource)
short resource;
#endif
{

#if defined(I_MS_DOS)

    unsigned short mask;
    unsigned short regval;

    /* build resource tag mask */
    mask = 1 << resource;

    /* loop while last interrupt remain unserviced */
    while (( i_glob.imghra->hstctll ) & I_INTIN );

    /* test for tag, return failure message if not present */
    if ((( i_glob.imghra -> dpyadr ) & mask ) == 0 )
        return ( 0 );

    /* send message to identify received tag */
    i_glob.imghra -> dpystrt = mask;

    /* send interrupt to verify tag */
    /* this is required for compatibility with other programs */
    /* linked with previous versions of the etag routines */
    /* can be removed if not necessary. */
    /* optional compatibility block starts here */

    regval = i_glob.imghra->hstctll;

    /* set MSGIN field to zero */
    regval &= ~I_MSGINMSK;

    /* set INTIN and MSGIN */
    i_glob.imghra->hstctll = regval | I_INTIN | I_MSG_ETAG_VERIFY;

    /* loop while last interrupt remain unserviced */
    while (( i_glob.imghra->hstctll ) & I_INTIN );

    /* test for tag, return failure message if not present */
    if ((( i_glob.imghra -> dpyadr ) & mask ) == 0 )
        return ( 0 );

    /* optional compatibility block ends here */

    /* send interrupt to GSP with etag_ack message */

    regval = i_glob.imghra->hstctll;

    /* set MSGIN field to zero */
    regval &= ~I_MSGINMSK;

    /* set INTIN and MSGIN */
    i_glob.imghra->hstctll = regval | I_INTIN | I_MSG_ETAG_ACK;

    /* return success message */
    return ( 1 );

#endif

#ifdef I_OS2

unsigned short out_buf;

DosDevIOCtl(&resource,&out_buf,
            (unsigned short)I_IQ_ETAG,
            (unsigned short)0x80,
            (HFILE)i_glob.board);
return(resource);

#endif

#ifdef  I_UNIX

    ioctl ( i_glob.board, IMG_IOIQETAG , &resource );

    /* actual return value put back into resource by ioctl call */
    return ( resource );

#endif

} /* ioiqetag() */

