/*
    filename :  ioputf.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

extern  I_IMGLOB    i_glob;

/*/     Function:   ioputf()
*       Synopsis:   This routine writes a float to the FIFO.
*       Date:       January 23rd 1990
*       param:      --- none ---
*                                               
*       returns:    word
**/

#ifdef ANSI
void FTYPE ioputf(float val)
#else
FTYPE ioputf( val )
float val;
#endif
    {

    /* Wait until enough space for two words becomes available. */

    while ( IOwrite_count > WRITE_FIFO_SIZE - 2 )
        ;


    /* Convert into short */

    val *= FLOATfactor;


    /* Sends LOW word first, then the HIGH word. */

    IOwrite = (short)  val;
    IOwrite = (short) ( (unsigned long) val >> 16 );

    }   /* ioputf() */
