
#include "imseries.h"
#include "imbind.h"
#include "proto.h"
/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _fpjprdmem
*/

extern unsigned long i_buff[];
extern  I_IMGLOB i_glob;

/* use for dummy read */
static short dummy;

/* SHey 94/03/07 Changed pointers for WATCOM compiler support */
/* They were defined as _I_PTYPE before */
#ifdef  ANSI
char _I_HRDWTYPE * FTYPE fpjprdmem(short p0)
#else
char _I_HRDWTYPE * FTYPE fpjprdmem(p0)
short p0;
#endif
{

    unsigned long *p, datal;

#ifdef PHAR_LAP
    _far char *charptr, *returnaddr;
    _far short *shortptr;
#else
   /* SHey 94/03/07 Changed pointers for WATCOM compiler support */
   /* They were defined as _I_PTYPE before */
	char _I_HRDWTYPE *returnaddr, _I_HRDWTYPE *charptr;
   short _I_HRDWTYPE *shortptr;
#endif

    p = i_buff;

    *p++ = (SECOND_DEC | FPJPRDMEM);
    *p++ = (long) p0;

    ioputbuf((short *) i_buff, 4);

    iogetbuf((short *) i_buff,2); 

    datal = i_buff[0];
    if (datal)
     {
       charptr = &( i_glob.vramhra->hctrl );
       *charptr |= 0x60;  /* set HAAS bits to 11 and set HAAEN bit */

       shortptr = &( i_glob.vramhra->gcdapr );
       *shortptr = (short)(datal >> 16);
       ioFlushIndexInADR((short _I_HRDWTYPE *)shortptr);

       dummy = *shortptr; /* necessary dummy read */

#ifdef PHAR_LAP
       returnaddr = (_far char *)(i_glob.vrammap->haa.cda +
                    (unsigned short)((datal & 0x0000ffff) >> 3));
#else
       /* SHey 94/03/07 Changed pointers for WATCOM compiler support */
       /* They were defined as _I_PTYPE before */
       returnaddr = (char _I_HRDWTYPE *) (i_glob.vrammap->haa.cda +
                    (unsigned short)((datal & 0x0000ffff) >> 3));
#endif
       /* SHey 94/03/07 Changed pointers for WATCOM compiler support */
       /* They were defined as _I_PTYPE before */
       return((char _I_HRDWTYPE *)returnaddr);
     }

    /* SHey 94/03/07 Changed pointers for WATCOM compiler support */
    /* They were defined as _I_PTYPE before */
    else return((char _I_HRDWTYPE *)0);

} /* fpjprdmem() */ 

