
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _pchlprocess
*/


extern I_IMGLOB i_glob;

#ifdef ANSI
void FTYPE pchlprocess( void )
#else
FTYPE pchlprocess()
#endif
{

#ifdef  I_MS_DOS

    unsigned short regval;

    /* loop while last interrupt remain unserviced */
    while (( i_glob.imghra->hstctll ) & I_INTIN );

    /* send interrupt to GSP with pchlprocess message */
    regval = i_glob.imghra->hstctll;

    /* set MSGIN field to zero */
    regval &= ~I_MSGINMSK;

    /* set INTIN and MSGIN */
    i_glob.imghra->hstctll = regval | I_INTIN | I_MSG_PCHLPROCESS;

#endif

#ifdef I_OS2

unsigned short resource,out_buf;

DosDevIOCtl(&resource,&out_buf,
            (unsigned short)I_HALT_PROCESS,
            (unsigned short)0x80,
            (HFILE)i_glob.board);


#endif

#ifdef  I_UNIX
    
    ioctl ( i_glob.board, IMG_PCHLPROCESS );

#endif

} /* pchlprocess() */ 

