/*/  Function name:  krhwdolcclr
*
*    Author:   Sylvain Carbonneau
*    Date:     July 9, 1991
*
*    Modification history:  
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*
*    Uses:  None
*
*    Return value:  None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;


#ifdef ANSI
void FTYPE krhwdolcclr(unsigned long color_index)
#else
FTYPE krhwdolcclr(color_index)
unsigned long color_index;
#endif
{
    ptrbuff = buff;

    *ptrbuff++ = 0x0182;
    *((long *)ptrbuff) = color_index;

    ioputbuf(buff, 3);
}


/*/  Function name:  krhwdolfclr
*
*    Author:   Sylvain Carbonneau
*    Date:     July 9, 1991
*
*    Modification history:  
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*
*    Uses:  None
*
*    Return value:  None
*/

#ifdef ANSI
void FTYPE krhwdolfclr(unsigned long color)
#else
FTYPE krhwdolfclr(color)
unsigned long color;
#endif
{
    ptrbuff = buff;

    *ptrbuff++ = 0x0180;
    *((long *)ptrbuff) = color;

    ioputbuf(buff, 3);
}


/*/  Function name:  krhwdolrclr
*
*    Author:   Sylvain Carbonneau
*    Date:     July 9, 1991
*
*    Modification history:  
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*
*    Uses:  None
*
*    Return value:  None
*/

#ifdef ANSI
void FTYPE krhwdolrclr(short left, short top, short right, short bottom,
                       unsigned long color)
#else
FTYPE krhwdolrclr(left, top, right, bottom, color)
short left, top, right, bottom;
unsigned long color;
#endif
{
    ptrbuff = buff;

    *ptrbuff++ = 0x0183;
    *ptrbuff++ = left;
    *ptrbuff++ = top;
    *ptrbuff++ = right;
    *ptrbuff++ = bottom;
    *((long *)ptrbuff) = color;

    ioputbuf(buff, 7);
}


/*/  Function name:  krhwdolsclr
*
*    Author:   Sylvain Carbonneau
*    Date:     July 9, 1991
*
*    Modification history:  
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*
*    Uses:  None
*
*    Return value:  None
*/

#ifdef ANSI
void FTYPE krhwdolsclr(unsigned long color)
#else
FTYPE krhwdolsclr(color)
unsigned long color;
#endif
{
    ptrbuff = buff;

    *ptrbuff++ = 0x0181;
    *((long *)ptrbuff) = color;

    ioputbuf(buff, 3);
}
