/*/  Function name:  lsdfont
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:  
*
*    Calls:  ioputmbuf:  send multiple buffers of words to the board.
*
*    Uses:  FONT data structure.
*
*    Return value:  None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;
IMPORT  unsigned short _I_PTYPE *i_buffers[];
IMPORT  unsigned short i_ns[];

#define BUFFER_SIZE 2    /* parameters buffer size in words */

#define STRUCT_SIZE 13   /* structure size in words */

#ifdef ANSI
void FTYPE lsdfont(unsigned short font_id, FONT _I_PTYPE *font_ptr)
#else
FTYPE lsdfont(font_id, font_ptr)
unsigned short  font_id;
FONT  _I_PTYPE *font_ptr;
#endif

	{
    unsigned short _I_PTYPE * _I_PTYPE *buffers, _I_PTYPE *ns;
    unsigned short  length_owtable = 0;
    unsigned short  length_data = font_ptr->pitch;

    if (!font_ptr->width)           /* Proportional-spaced font */
        length_owtable = font_ptr->lastch_off + 2;

    if (font_ptr->fmt & 0x0001)     /* Raster font */
        length_data *= font_ptr->height;
    else                            /* Stroke font */
        length_owtable += font_ptr->lastch_off + 2;

    /* set buffer for parameters */
    ptrbuff = buff;

    *ptrbuff++ = 0x0065;
    *ptrbuff = font_id;

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short _I_PTYPE *)buff;
    /* then the structure values */
    *buffers++ = (unsigned short _I_PTYPE *)font_ptr;

    /* other buffers in structure */
	if (length_owtable)
		*buffers++ = (unsigned short _I_PTYPE *)font_ptr->owtable;

	*buffers++ = (unsigned short _I_PTYPE *)font_ptr->kerntable;
	*buffers = (unsigned short _I_PTYPE *)font_ptr->data;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = (unsigned short) BUFFER_SIZE;
    /* structure size ( in words ) */
    *ns++ = (unsigned short) STRUCT_SIZE;

    /* conditional length of buffers in structure */
    if (length_owtable)
        *ns++ = length_owtable;

	*ns++ = (unsigned short) font_ptr->nkpairs;
	*ns = length_data;

    /* send buffers */
	if (length_owtable)
		ioputmbuf ( i_buffers, i_ns, 5 );
	else
		ioputmbuf ( i_buffers, i_ns, 4 );

    }


