/*  Function name:  lswrrst
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:  
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*
*    Uses:  None
*
*    Return value:  -1: if the routine is not able to open the file
*                    0: otherwise
*/

#include  <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#define   TEMPBUFFSIZE   1024
/*        Size of a disk cluster, 1024Kwords or 2048Kbytes */

IMPORT unsigned short  tempbuff[];
/*        This buffer is also declared in lsrdrst() */

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;


#ifdef ANSI
short FTYPE lswrrst(short left, short top, short right, short bottom,
                    char _I_PTYPE *src_filename)
#else
short FTYPE lswrrst(left, top, right, bottom, src_filename)
short  left, top, right, bottom;
char  _I_PTYPE *src_filename;
#endif

    {
    FILE    _I_PTYPE *fpr;                          /* Input file pointer */
    unsigned long  length;
    unsigned short  numread;

    ptrbuff = buff;

    *ptrbuff++ = 0x001F;
    *ptrbuff++ = left;
    *ptrbuff++ = top;
    *ptrbuff++ = right;
    *ptrbuff = bottom;

    ioputbuf(buff, 5);

    if ((fpr = fopen(src_filename, "rb")) == NULL)
        return(-1);

    length = ((long)(right - left + 1) * (long)(bottom - top + 1) + 1) >> 1;

    while (length)
        {
        if (length > TEMPBUFFSIZE)
            {
            numread = TEMPBUFFSIZE;
            length -= TEMPBUFFSIZE;
            }
        else
            {
            numread = (unsigned short) length;
            length = 0;
            }

        fread((char *)tempbuff, sizeof(short), numread, fpr);

        ioputbuf((short *) tempbuff, numread);
        }

    fclose(fpr);

    return(0);
    }


