/*
    filename:   ls_kr.h
    Synopsis:   functions prototypes for graphics kr module
    Date:       March the 19th 1991

COPYRIGHT (c) 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_LS_KR_H__
#define __I_LS_KR_H__

/* Need imseries.h for I_UNIX defines */
#ifndef __I_IMSERIES_H__
#include "imseries.h"
#endif /* __I_IMSERIES_H__ */

/* Need i_dll.h for FTYPE */
#ifndef __I_I_DLL_H__
#ifdef I_UNIX
#include <im_series/i_dll.h>
#else
#include "i_dll.h"
#endif /* I_UNIX */
#endif /* __I_I_DLL_H__ */

/* Need def.h for definitions */
#ifndef __I_DEF_H__
#ifdef I_UNIX
#include <im_series/def.h>
#else
#include "def.h"
#endif /* I_UNIX */
#endif /* __I_DEF_H */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void FTYPE krgcdi(void );
void FTYPE lsgcdi(void );
void FTYPE krgcen(void );
void FTYPE lsgcen(void );
void FTYPE krgcfr(void );
void FTYPE krgcmv(short x,short y);
void FTYPE krgcsda(struct Gcattr _I_PTYPE *gcspecptr);
void FTYPE krgcsdm(short disp_mode);
void FTYPE lsgcsdm(short disp_mode);
void FTYPE krhwcclr(unsigned short color_index);
void FTYPE krhwcprss(short spx,short spy,short dpx,short dpy,short sizex,
                     short sizey,short theta);
void FTYPE krhwcpss(short spx,short spy,short dpx,short dpy,short sizex,
                    short sizey);
void FTYPE krhwcpxmss(short spx,short spy,short dpx,short dpy,short sizex,
                      short sizey);
void FTYPE krhwcpymss(short spx,short spy,short dpx,short dpy,short sizex,
                      short sizey);
void FTYPE krhwslfborg(short fborg);
void FTYPE krhwfclr(unsigned short color_index);
void FTYPE krhwgcls(void );
void FTYPE krhwgpix(short x,short y);
void FTYPE krhwdolcclr(unsigned long color_index);
void FTYPE krhwdolfclr(unsigned long color);
void FTYPE krhwdolrclr(short left, short top, short right, short bottom,
                       unsigned long color);
void FTYPE krhwdolsclr(unsigned long color);
void FTYPE krhwrclr(short left,short top,short right,short bottom,
                    unsigned short color_index);
void FTYPE krhwrcls(void );
void FTYPE krhwsbcol(unsigned short color_index);
void FTYPE krhwstlbcol(unsigned long color_index);
void FTYPE krhwsbop(short bool_operator);
void FTYPE krhwsclipr(short left,short top,short right,short bottom);
void FTYPE krhwsclr(unsigned short color_index);
void FTYPE krhwscls(unsigned long line_style);
void FTYPE krhwsdirect(short mode);
void FTYPE krhwsfcol(unsigned short color_index);
void FTYPE krhwstlfcol(unsigned long color_index);
void FTYPE krhwsils(unsigned long new_style);
void FTYPE krhwsmsk(unsigned short mask);
void FTYPE krhwstlmsk(unsigned long mask);
void FTYPE krhwspix(short x,short y,unsigned short color_index);
void FTYPE krhwstlpix(short x,short y,unsigned long color_index);
void FTYPE krhwsscol(unsigned short color_index);
void FTYPE krhwstlscol(unsigned long color_index);
void FTYPE krhwssmsk(unsigned short mask);
void FTYPE krhwstlsmsk(unsigned long mask);
void FTYPE krhwstdef(unsigned short mode);
void FTYPE krhwslcsurf(short surfn);
void FTYPE krhwszp(short zoomx,short zoomy,short panx,short pany,
                   short finepanx,short finepany);
void FTYPE krhwubps(short sy,short xstart,short xend);
void FTYPE krhwufps(short sy,short xstart,short xend);
void FTYPE krhwwbps(short sy,short xstart,short xend);
void FTYPE krhwwfps(short sy,short xstart,short xend);
void FTYPE kriossmode(short swapmode);

#ifdef  __cplusplus
}
#endif /* __cplusplus */
#endif /* __I_LS_KR_H__ */
