/*
    filename:   ls_sc.h
    Synopsis:   functions prototypes for graphics sc module
    Date:       March the 19th 1991

COPYRIGHT (c) 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_LS_SC_H__
#define __I_LS_SC_H__

/* Need imseries.h for I_UNIX defines */
#ifndef __I_IMSERIES_H__
#include "imseries.h"
#endif /* __I_IMSERIES_H__ */

/* Need i_dll.h for FTYPE */
#ifndef __I_I_DLL_H__
#ifdef I_UNIX
#include <im_series/i_dll.h>
#else
#include "i_dll.h"
#endif /* I_UNIX */
#endif /* __I_I_DLL_H__ */

/* Need def.h for definitions */
#ifndef __I_DEF_H__
#ifdef I_UNIX
#include <im_series/def.h>
#else
#include "def.h"
#endif /* I_UNIX */
#endif /* __I_DEF_H */


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void FTYPE scaraplygn(unsigned short nvert,struct Phcoord _I_PTYPE *vertptr);
void FTYPE scarbfill(short x,short y,unsigned short color_index);
void FTYPE scarellipse(unsigned short a,unsigned short b,short cx,short cy);
void FTYPE scarepie(short sth,short eth,unsigned short a,unsigned short b,
                    short cx,short cy);
void FTYPE scareseg(short sth,short eth,unsigned short a,unsigned short b,
                    short cx,short cy);
void FTYPE scarffill(short x,short y);
void FTYPE scarrect(short x0,short y0,short x1,short y1);
void FTYPE scarrrect(short x0,short y0,short x1,short y1,unsigned short a,
                     unsigned short b);
void FTYPE scarspin(short pin_flag);
void FTYPE scartri(short x1,short y1,short x2,short y2,short x3,short y3);
void FTYPE scarwplygn(unsigned short nvert,struct Phcoord _I_PTYPE *vertptr);
void FTYPE scolearc(short sth,short eth,unsigned short a,unsigned short b,
                    short cx,short cy);
void FTYPE scolellipse(unsigned short a,unsigned short b,short cx,short cy);
void FTYPE scolepie(short sth,short eth,unsigned short a,unsigned short b,
                    short cx,short cy);
void FTYPE scoleseg(short sth,short eth,unsigned short a,unsigned short b,
                    short cx,short cy);
void FTYPE scolhpearc(float sth,float eth,unsigned short a,unsigned short b,
                      short cx,short cy);
void FTYPE scolhspline(short x0,short y0,short x1,short y1,short x2,short y2,
                       short x3,short y3,unsigned short nsteps);
void FTYPE scollnto(short x,short y);
void FTYPE scolmvto(short x,short y);
void FTYPE scolpline(unsigned short nvert,struct Phcoord _I_PTYPE *vertptr);
void FTYPE scolplygn(unsigned short nvert,struct Phcoord _I_PTYPE *vertptr);
void FTYPE scolrect(short x0,short y0,short x1,short y1);
void FTYPE scolrrect(short x0,short y0,short x1,short y1,unsigned short a,
                     unsigned short b);
void FTYPE scolseshp(short begin_sh,short middle_sh,short end_sh);
void FTYPE scolsmode(unsigned short mode);
void FTYPE scolsw(short new_width);
void FTYPE scsorg(unsigned short x,unsigned short y);
void FTYPE scsthincr(short theta);
void FTYPE sctxbstring(short x,short y,unsigned char _I_PTYPE *strptr);
void FTYPE sctxsalign(short halign,short valign);
void FTYPE sctxsbf(short bolding_factor);
void FTYPE sctxsblrot(short baseline_angle);
void FTYPE sctxsbx(float extra_space);
void FTYPE sctxschrot(short rot_angle);
void FTYPE sctxsdmode(short mode);
void FTYPE sctxsim(unsigned short ital_mask);
void FTYPE sctxsincs(short inter_char);
void FTYPE sctxslm(unsigned short lightmask);
void FTYPE sctxssf(float xscale,float yscale);
void FTYPE sctxssow(unsigned short strike_out_thick);
void FTYPE sctxssw(unsigned short stroke_width);
void FTYPE sctxstring(short x,short y,short _I_PTYPE *strptr);
void FTYPE sctxsuw(short underline_thick);
void FTYPE sctxswpw(short width);

#ifdef  __cplusplus
}
#endif /* __cplusplus */
#endif /* __I_LS_SC_H__ */
