;C:SAVEPCP save plot setup info as EED added to first entity
;in the drawing

;This program is used in conjunction with MULTIPLT.LSP to batch plot
;See MULTIPLT.TXT for more information

;Sierra Hermitage
;Rod Young, programmer
;140 Mesa Vista Drive
;Bishop, CA  93514
;Phone 619-387-2479 (voice)   619-387-2488 (data/fax, seldom enabled)
;E-mail hermit1@ix.netcom.com

(defun C:SAVEPCP()
   ;register this application
   (if (tblsearch "appid" "SAVEPCP")
      (princ (strcat "\nSAVEPCP already exist."))
      ;register savepcp and check success
      (if (= (regapp "SAVEPCP") nil)
         (princ (strcat "\nCan't register XDATA for SAVEPCP."))
      );end if
   );end if
   ;get the pcp filename
   (setq pcp(getfiled "Choose PCP File" "" "pcp" 2))
   (setq pid(getvar "plotid"))
   (setq pscale(getreal "\nEnter the plot scale "))
   (setq strg(strcat "PCP FILE: " pcp " | PLOTTER: " pid " |  SCALE: " (rtos pscale 2 2)))
   (setq extdta (list (list -3 (list "SAVEPCP" (cons 1000 strg)))))
   ;now add it to entity
   (setq ent(entget(entnext)))
   (setq ent(append ent extdta))
   ;now update the entity
   (entmod ent)
   (princ)
);end defun