-----------------------------------------------------------------
VOUCH  version  1.1.  Copyright (c) 1993, 1994  Awais M. Hussain.
-----------------------------------------------------------------
<blnr.c>
<blnrasm.asm>

Basic LN arithmetic routines.

Most of the routines are coded in assembly using the Pascal
model.  These routines use the 386-instruction set, i.e., 32-bit
arithmetic operations. The routines assume that the lengths of LNs
are specified correctly, i.e., there are no leading (MS)
zero-long-integers.

==================================================================
1.
far pascal isLess( lenLN Lo1, ptrLN  o1, lenLN Lo2, ptrLN o2 ) ;

(Lo1,o1) < (Lo2,o2)  => return( 1 ).
Checks if LN (Lo1,o1) is strictly less than the LN (Lo2,o2).

I: Lo1, o1, Lo2, o2

2.
far pascal isGreater( lenLN Lo1, ptrLN o1, lenLN Lo2, ptrLN o2 ) ;

(Lo1,o1) > (Lo2,o2) => return( 1 ).
Checks if the LN (Lo1,o1) is strictly greater than the LN (Lo2,o2).

I: Lo1, o1, Lo2, o2

3.
far pascal isEqual( lenLN Lo1, ptrLN o1, lenLN Lo2, ptrLN o2 ) ; 

(Lo1,o1) == (Lo2,o2)  => return( 1 ).
Checks for equality of the two LNs.

I: Lo1, o1, Lo2, o2

4.
far pascal 
shiftL( unsigned bshft, lenLN Lo, ptrLN oo, lenLN  *Los, ptrLN os ) ;

(Los,os) = shift_left (Lo,oo) by bshft-bits.

The LN (Lo,oo) is shifted left by bshft-bits and the result is
returned in the LN (Los,os). Zeros are shifted in at the right end.
A shift-left by one bit corresponds to multiplication by 2.  No
overflow at the left-end occurs since "Los" is incremented, if
required. The input LN (Lo,oo) remains unchanged.

I: Lo, oo
I: bshft
O: Los, os

5.
far pascal 
shiftR( unsigned bshft, lenLN Lo, ptrLN oo  lenLN *Los, ptrLN os ) ;

(Los,os) = shift_right (Lo,oo) by bshft-bits.

The LN (Lo,oo) is shifted right by bshft-bits and the result is
returned in the LN (Los,os). Zeros are shifted in at the left-end
and bits are lost at the right-end.  A shift-right by one bit
corresponds to integer-division by 2.  The input LN (Lo,oo)
remains unchanged.

I: bshft
I: Lo, oo
O: Los, os

6.
far pascal 
accum( lenLN Lox, ptrLN ox, lenLN *Lrr, ptrLN rr )  ;

(Lrr,rr) = (Lrr,rr) + (Lox,ox) 

Accumulates into (Lrr,rr), the LN (Lox,ox). No overflow occurs.

I: Lox, ox
I/O: Lrr, rr

7.
far pascal subt( lenLN Lox, ptrLN ox, lenLN *Lrr, ptrLN rr ) ;

(Lrr,rr) = (Lrr,rr) - (Lox,ox) ;  (Lrr,rr) >= (Lox,ox)

Subtracts from (Lrr,rr), the LN (Lox,ox). The result is returned in
(Lrr,rr). The input LN (Lrr,rr) must be greater or equal than
(Lox,ox). Recall that a LN represents only non-negative integers.

I: Lox, ox
I/O: Lrr, rr

8.
far pascal 
mult( lenLN Lo1, ptrLN o1, lenLN Lo2, ptrLN o2, lenLN *Lrr, ptrLN rr) ; 

(Lrr,rr) = (Lo1,o1) * (Lo2,o2)

I: Lo1, o1, Lo2, o2
O: Lrr, rr

The operands (Lo1,o1) and (Lo2,o2) are multiplied together and the
result is returned in (Lrr,rr). No overflow occurs. This routine
calls multASM(). The two input LNs may be the same (for squaring),
i.e., the following is legal:

unsigned Lrr, Lo1=3 ;
long unsigned o1[3] = {77,33,0xffffffff} ;
long unsigned rr[7] ;

mult( Lo1, o1, Lo1, o1, &Lrr, rr) ;


9. void  divide( lenLN Ldr, ptrLN dr, lenLN Ldd, ptrLN dd,
		 lenLN *Lqt, ptrLN qt, lenLN *Lrr, ptrLN rr ) ;

(Lqt,qt) = (Ldd,dd) / (Ldr,dr) ; integer-divison
(Lrr,rr) = (Ldd,dd) % (Ldr,dr) ; modulo-reduction

I: Ldr, dr, Ldd, dd
O: Lqt, qt, Lrr, rr

The dividend LN (Ldd,dd) is divided by the divisor LN (Ldr,dr). The
quotient LN is stored in (Lqt,qt) and the remainder LN in (Lrr,rr).
The routine works by repeated shift-and-subtract and calls other LN
routines in this module. Division is the slowest of the arithmetic
operations. 

10.
void modR( lenLN Ldd, ptrLN dd, lenLN Ldr, ptrLN dr,
          			lenLN *Lrr, ptrLN rr ) ;

(Lrr,rr) = (Ldd,dd) % (Ldr,dr) ; modulo-reduction

I: Ldd, dd, Ldr, dr
O: Lrr, rr

Same as the divide() routine except that it does not return the
quotient.

===============================================================

11. 
multASM()

This assembly routine is called by mult(). It should not be called
directly. 

=================================================================
