-----------------------------------------------------------------
VOUCH  version  1.1.  Copyright (c) 1993, 1994  Awais M. Hussain.
-----------------------------------------------------------------
<gfmr.c>

"Galois-field modulo arithmetic routines". Implements routines which
use the basic arithmetic routines in <blnr.c>

===================================================================

1.
void gcd( lenLN La, ptrLN aa, lenLN Ln, ptrLN nn,
                              lenLN *Lgp, ptrLN gp ) ;

(Lgp,gp) = g.c.d( (Laa,aa), (Lnn,nn) ) 

Finds the greatest common divsior of LNs (Laa,aa) and (Lnn,nn) using
the Euclid algorithm.

I: Laa, aa, Ln, nn
O: Lgp, gp

2.
void inverse( lenLN La, ptrLN aa, lenLN Ln, ptrLN nn, 
                                  lenLN *Lia, ptrLN ia ) ; 

(Lia,ia) = inverse( (La,aa) ) mod  (Ln,nn) 
i.e., (Lia,ia) * (La,aa) = 1 mod (Ln,nn) 

Finds (modulo) inverse of a number. Uses Euclid algorithm.
For example, the inverse of 5 in GF(7) is 3, since 5*3 = 1 mod 7.

I: La, aa, Ln, nn
O: Lia, ia

3.
void 
psor( lenLN Lbb, ptrLN bb, lenLN Lpp, ptrLN pp, lenLN *Lrr, ptrLN rr ) ;

Pseudo-modulo reduction by partial sum-of-residues.
(Lrr,rr) = (Lbb,bb) pseudo_mod (Lpp,pp).

I: Lbb, bb, Lpp, pp
O: Lrr, rr

Since modulo reduction requires a division (extremely time
consuming), a technique of pseudo-modulo presented by B.A.Johnson [1]
can be used for mathematical-functions which require frequent modulo
operations. This method works by generating a table-of-residues of the
modulus (Lpp,pp). The table is generated/extended automatically by
calls to ext_residues() within psor(). Before the first call to
psor(), set the global variable Nres=Lpp. 


4.
void 
ext_residues( lenLN Lpp, ptrLN pp, unsigned oNres, unsigned nNres ) ;

Extend/generate residue-table of the LN (Lpp,pp) required by psor(). 
The table is held in rs[], declared as

ptrLN  rs[380] ;  /* 1..379 */
lenLN  Lrs[380] ; /* 1..379 */

The Lrs[i] is the length of the LN rs[i]. The residues #oNres+1 thru
#nNres are generated and stored in rs[oNres+1-Lpp] thru
rs[nNres-Lpp]. The global variable Nres is updated to nNres.

I: Lpp, pp, oNres, nNres

5.
void clear_rs( unsigned Lpp ) ;

Dispose residue-table. The memory allocated to residue-table rs[] is
freed. This must be used at the end of the program that used psor().
It is also called before psor() computations with a different modulus are
required. 

I: Lpp

As an example of the use of psor(), ext_residues(), and clear_rs(),
suppose it is desired to multiply a LN (Lx1,x1) with itself 10 times
modulo (Lpp,pp):

long unsigned x1[12], pp[12], rr[12], tt[12] ;
unsigned Lx1=5, Lpp=5, Lrr, Ltt ;

/* fill x1 and pp with data */

Nres=Lpp ;
Lrr=Lx1; movmem(x1,rr,4*Lx1) ; /* copy x1 into rr */

for (i=1; i<10; ++i) {
  mult(Lrr,rr,Lx1,x1,&Ltt,tt) ;  /*   tt = x1 * rr               */
  psor(Ltt,tt,Lpp,pp,&Lrr,rr) ;  /*   rr = tt  pseudo_mod pp     */
}
modR(Lrr,rr,Lpp,pp,&Ltt,tt) ;    /*   tt = rr mod pp             */
/* The final result is contained in (Ltt,tt). The last modulo
reduction by modR() is necessary, since pseudo_mod is only a 
partial reducer. Suppose now computation with a different 
modulus (Lqq,qq) are desired: */

clear_rs( Lpp ) ; /* clear previoius residue-table of (Lpp,pp), if there */
Nres = Lqq ;      /* set-up for residue-table of (Lqq,qq)  */
 computations  ..... ;
..... ............... ;
psor(.,., Lqq, qq, ., . ) ; 
                          /* ext_residues() is called within psor()*/
.....................;

Finally, when allocating space for LNs, a small psor() overhead needs
to be taken care of. In the above example, since Lpp=Lx1=5, the
product needs 10 words. In this case we allow 12 in the declaration.
The actual amount of overhead required is explained in [1].


6.
void dexp( lenLN Lx,  ptrLN xx, lenLN Ln,  ptrLN nn,
	   lenLN Lpp, ptrLN pp, lenLN *Le, ptrLN ee ) ;

(Le,ee) = power( (Lx,xx), (Ln,nn) )  mod (Lpp,pp)  

Modular discrete exponentiation. 

I: Lx, xx, Ln, nn, Lpp, pp
O: Le, ee

Since the routine calls psor(),
before calling dexp(), set Nres=Lpp if the residue-table for (Lpp,pp)
does not already exist (see above). If the residue-table exists, but
for some other modulus (other than (Lpp,pp)), do:

clear_rs( Lqq ) ; /* assuming that the residue-table for (Lqq,qq)
                     existed. If no residue-table exists, 
                     omit this call.                            */
Nres = Lpp ;
dexp(.,.,.,., Lpp, pp, .,. ) ;
............................
dexp(.,.,.,., Lpp, pp, .,. ) ; /* subsequent calls to dexp(), with
                                  modulus (Lpp,pp), use
                                  the existing residue-table.

The algorithm used for exponentation is one of Knuth's (or its
variant); consult his books. 


7.
void dexp2( lenLN Lx1, ptrLN x1, lenLN Ln1, ptrLN n1,
            lenLN Lx2, ptrLN x2, lenLN Ln2, ptrLN n2,
	    lenLN Lpp, ptrLN pp, lenLN *Le, ptrLN ee )

(Le,ee) = ( power( (Lx1,x1), (Ln1,n1) ) * 
            power( (Lx2,x2), (Ln2,n2) ) )  mod (Lpp,pp)

Modular product discrete exponentiation. This is a lot faster than
using dexp() separately and multiplying. The comments above for dexp()
apply. The algorithm used is again perhaps Knuth's.

I: Lx1, x1, Ln1, n1, Lx2, x2, Ln2, n2, Lpp, pp
O: Le, ee
===================================================================

unsigned Nres = 16 ;

Before calling modular arithmetic routines, set "Nres" equal to the
length of the modulus as explained above.

====================================================================

[1] P.A. Findlay and B.A. Johnson,
    "Modular exponentiation using recursive sum of residues,"
    in Proceedings of CRYPTO '89, G.Brassard (Ed),
    Lecture Notes in Computer Science (435), Springer-Verlag, 1990,
    pp. 371-386.
