
typedef unsigned lenLN ;
typedef long unsigned  *ptrLN ;

/****************** blnr.c ******************************/

int isLess( lenLN Lo1, ptrLN  o1, lenLN Lo2, ptrLN o2 ) ;
/* o1 < o2 => isLess */

int isGreater( lenLN Lo1, ptrLN o1, lenLN Lo2, ptrLN o2 ) ;
/* o1 > o2 => isGreater */

int isEqual( lenLN Lo1, ptrLN o1, lenLN Lo2, ptrLN o2 ) ;
/* o1 = o2 => isEqual */

void shiftL( unsigned bshft, lenLN Lo, ptrLN oo,
				    lenLN  *Los, ptrLN os ) ;
/* os := shift_Left oo by bshft_bits  */

void shiftR( unsigned bshft, lenLN Lo, ptrLN oo,
				     lenLN *Los, ptrLN os ) ;
/* os := shift_Right oo by bshft_bits  */

void accum( lenLN Lox, ptrLN ox, lenLN *Lrr, ptrLN rr )  ;
/* rr := rr + ox */

void subt( lenLN Lox, ptrLN ox, lenLN *Lrr, ptrLN rr ) ;
/* rr := rr-ox ; rr > ox */

void mult( lenLN Lo1, ptrLN o1, lenLN Lo2, ptrLN o2,
				      lenLN *Lrr, ptrLN rr ) ;
/* rr := o1 * o2 */

void divide( lenLN Ldr, ptrLN dr, lenLN Ldd, ptrLN dd,
		 lenLN *Lqt, ptrLN qt, lenLN *Lrr, ptrLN rr ) ;
/* divisor: dr  ;  dividend: dd */
/* quotient: qt := dd div dr  ; remainder: rr := dd mod dr */

void modR( lenLN Ldd, ptrLN dd, lenLN Ldr, ptrLN dr,
					  lenLN *Lrr, ptrLN rr ) ;
/* divisor: dr  ;  dividend: dd */
/* remainder: rr := dd mod dr */


/*********************** gfmr.c ********************************/

/* Euclid's greatest common divisor */
void gcd( lenLN La, ptrLN aa, lenLN Ln, ptrLN nn,
                                      lenLN *Lgp, ptrLN gp ) ;
/* gp = gcd( aa, nn) */

/* Euclid inverse : solve for x such that aa * x mod nn = 1 */
/* 0 < aa < nn ; gcd(aa,nn) = 1 */
void inverse( lenLN La, ptrLN aa, lenLN Ln, ptrLN nn,
                                       lenLN *Lia, ptrLN ia ) ;
/* ia = inverse( aa ) mod nn ;  aa < nn */

/* modular reduction by partial_sum_of_residues */
void psor( lenLN Lbb, ptrLN bb, lenLN Lpp, ptrLN pp,
                                       lenLN *Lrr, ptrLN rr ) ;
/* requires residue_table generated by procedure <ext_residues> */
/* The table is generated automatically by calls to ext_residues as needed.*/
/* Before the first call to psor set Nres := Lpp */
/* rr = bb partial_mod pp */

/* Modular Discrete Exponentiation */
void dexp( lenLN Lx, ptrLN xx, lenLN Ln, ptrLN nn,
                lenLN Lpp, ptrLN pp, lenLN *Le, ptrLN ee ) ;
/* requires residue_table */
/* ee = power( xx, nn )  mod pp  */

/* Modular product discrete exponentiation */
void dexp2( lenLN Lx1, ptrLN x1, lenLN Ln1, ptrLN n1,
            lenLN Lx2, ptrLN x2, lenLN Ln2, ptrLN n2,
	    lenLN Lpp, ptrLN pp, lenLN *Le, ptrLN ee ) ;
/* ee = ( power( x1, n1 ) * power( x2, n2 ) )  mod pp  */


/* dispose residue array ( rs[] ) */
void clear_rs( unsigned Lpp ) ;


/************************** vfio.c *****************************/

/* write a LongNumber <Lxx,xx> to file <fname> */
/* if crf then create_file else append_file    */
/**/
int writeLN( unsigned crf, const char *fname, lenLN Lxx, ptrLN xx ) ;

/* read the <ind>-th LongNumber in <Lxx,xx> from file <fname> */
/**/
int readLN( unsigned ind, const char *fname, lenLN  *Lxx, ptrLN xx ) ;

/* truncate file after the ind-th line */
int trunc( unsigned ind, const char * fn ) ;

/* write comment */
int writeS( unsigned crf, const char *fname, char *cmnt ) ;

/*  fn2 = fn1 with new extension (nExt) */
void fExt( const char *fn1, const char *nExt, char *fn2 ) ;

/* cp=1 : make a copy of file <fn1> and name it <fn2> */
/* cp=0 : append file <fn1> to <fn2> */
int copyFile( const char *fn1, const char *fn2, int cp ) ;

/* return 0, if file exists */
int existFile( char *fname ) ;

/*********************  timer.c *************************/

void timeI( void ) ;

void timeF( float  *tm ) ;

/*********************** t86.asm *********************/

int far test8086( void ) ;


/************************ feal.c ****************************/

/*1
encrypt/decrypt a LongNumber (Lvv, vv) using 16-32-char password */
/* (enc = true) => encrypt */
/* encryted vector length is incremented by 1, if the input length is odd */

void  cryptLN( int  enc, char  *pswd, lenLN  *Lvv, ptrLN  vv ) ;


/**************** rndm.c *******************************/

void randomLN( unsigned *Lrr, ptrLN rr ) ;
/* return a random longNumber of length <= Lrr  */
/* mod the result yourself */

void init_rndm( void ) ;

/******************** vio.c *****************************/

/* get password */
int getPswd( char *pswd, int *lp ) ;

/* store individualization string */
void init_keyW( char *fn ) ;

/* read individualization string */
void read_keyW( char *fn ) ;
