/**<vstc.c>**************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <vstc.man> for documentation. 
SecurityTool (cap) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <io.h>
#include <dir.h>
#include <process.h>
#include <time.h>
#include "vst.h"

int brew( char *fn, int kind ) ;

char vpath[76] ;

int brew( char *fn, int kind )
{
  char frname[14], fno[14], fnx[80], xpath[80], *epath, msg[100] ;
  int err ;

  strcpy(xpath, vpath) ;
  switch (kind) {
    case 1:
      strcpy( msg, "STC: ENCRYPTING. . . <") ;
      strcat( msg, fn ) ;
      writeLog( msg ) ;
      geName( frname ) ;
      fExt( frname, ".cph", fno ) ;
      while (kbhit()) getch() ;
      cputs("Enter recipents's public_key filename: ") ; gets( fnx ) ;
      strcat( xpath, "vch.exe" ) ;
      err = spawnl( P_WAIT, xpath, "vch.exe", "/c", fn, fno, fnx, (char*)0 ) ;
      strcpy(fn,fno) ;
      return(err) ;
    case 2:
      strcpy( msg, "STC: SIGNING. . . <" ) ;
      strcat( msg, fn ) ;
      writeLog( msg ) ;
      epath = getenv( "VCH" ) ;
      if (epath!=NULL)  {
        strcpy(fnx, epath ) ;
        strcat(fnx,"\\r_sign.vch") ;
      }
      else
        strcpy(fnx, "r_sign.vch") ;
      geName( frname ) ;
      fExt( frname, ".sgn", fno ) ;
      strcat( xpath, "vch.exe" ) ;
      if ( access(fnx,0)==0 )
        err = spawnl( P_WAIT, xpath, "vch.exe", "/fsgn", fn, fno, (char*)0 ) ;
      else
        err = spawnl( P_WAIT, xpath, "vch.exe", "/sgn", fn, fno, (char*)0 ) ;
      strcpy( fn, fno) ;
      return(err) ;
    case 3:
      strcpy( msg, "STC: HASH. . . <" ) ;
      strcat( msg, fn ) ;
      writeLog( msg ) ;
      geName( frname ) ;
      fExt( frname, ".hsh", fno ) ;
      strcat( xpath, "vch.exe" ) ;
      err = spawnl( P_WAIT, xpath, "vch.exe", "/h", fn, fno, (char*)0 ) ;
      strcpy( fn, fno ) ;
      strcpy(msg, "STC: SIGNATURE. . . <" ) ;
      strcat( msg, fn ) ;
      writeLog( msg ) ;
      epath = getenv( "VCH" ) ;
      if (epath!=NULL)  {
        strcpy(fnx, epath ) ;
        strcat(fnx,"\\r_sign.vch") ;
      }
      else
        strcpy(fnx, "r_sign.vch") ;
      geName( frname ) ;
      fExt( frname, ".sig", fno ) ;
      if ( access(fnx,0)==0 )
        err = spawnl( P_WAIT, xpath, "vch.exe", "/fsig", fn, fno, (char*)0 ) ;
      else
        err = spawnl( P_WAIT, xpath, "vch.exe", "/sig", fn, fno, (char*)0 ) ;
      strcpy( fn, fno) ;
      return(err) ;
    case 4:
      strcpy( msg, "STC: SIX-BIT ENCODING. . . <" ) ;
      strcat( msg, fn ) ;
      writeLog( msg ) ;
      geName( frname ) ;
      fExt( frname, ".eml", fno ) ;
      strcat(xpath, "b2a.exe" ) ;
      err = spawnl( P_WAIT, xpath, "b2a.exe", fn, fno, (char*)0 ) ;
      strcpy( fn, fno ) ;
      strcpy( msg, "OutFILE: <" ) ;
      strcat( msg, fn ) ;
      writeLog( msg ) ;
      return(err) ;
  }
  return(1) ;
}/*brew*/

main( int argc, char *argv[] )
{
  int i, ix, nn, sq[8] ;
  time_t tx ;
  char sequence[100], msg[100], *cDir ;
  char fn[80], fn2[80], drv[4], dir[76], name1[14], name2[14],
       ext1[5], ext2[5] ;

/*1*/
  if ((argc<2) || (argc>3)) {
    puts("  SecurityTool (cap): VCH 1.1: Copyright (c) 1993, 1994  Awais M. Hussain " ) ;
    puts("Usage: vSTc.exe  <inFile>  [vch_Path] " ) ;
    exit(1) ;
  }
  strcpy( fn, argv[1] ) ;
  if (access(fn,0)) {
    printf("File <%s> not found.\n", fn) ;
    exit(errno) ;
  }
/*2*/
  if (argc==1)  strcpy(vpath, "c:\\vch" ) ;
    else strcpy( vpath, argv[2] ) ;
  strcat( vpath, "\\" ) ;

  randomize() ;
/*3*/
  puts("OPTIONS:") ;
  puts("        1: Encryption ") ;
  puts("        2: Sign ") ;
  puts("        3: Hash & Signature") ;
  puts("        4: Six-bit encode\n ") ;
  while (kbhit()) getch() ;
  cputs("Enter options sequence (e.g., 1 2 4 ): ") ;
  i = ix = 0 ;
  gets( sequence ) ;
  while ( (nn= sequence[i++]-48) != -48 ) {
    if ((nn<5) && (nn>0)) {
      sq[ix++] = nn ;
      if (ix>6) {
        puts("Too many steps. Halting.") ;
        exit(11) ;
      }
    }
  }
  if (ix==0) exit(13) ;

/*4*/
  strcpy(msg,"\n==========================\nVCH SecurityTool STC 1.1 #  ") ;
  time( &tx ) ;
  strcat(msg,ctime(&tx)) ;
  writeLog( msg ) ;

  strcpy(msg,"VOUCH_Directory = ") ;
  cDir = getenv( "VCH" ) ;
  if (cDir==NULL) {
    getcwd(fn2, 80) ;
    strcat(msg,fn2) ;
  } else strcat(msg,cDir) ;
  writeLog(msg) ;
/*5*/
  for (i=0; i<ix; ++i) {
    if ( (brew(fn,sq[i])) != 0 ) {
      puts("Halting. ") ; exit(19) ;
    }
    if (sq[i]==3) break ;
  }
/*6*/
  fnsplit( fn, drv, dir, name1, ext1 ) ;
  fnsplit( argv[1], drv, dir, name2, ext2 ) ;
  fnmerge( fn2, drv, dir, name2, ext1 ) ;
  if (access(fn2,0)) {
    rename( fn, fn2 ) ;
    strcpy( fn, fn2 ) ;
  }
  strcpy(sequence, "STC: OutFile: >") ;
  strcat( sequence, fn ) ;
  writeLog( sequence ) ;
}