/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public class DefaultEditorKit
extends EditorKit {
    public static final String EndOfLineStringProperty = "__EndOfLine__";
    public static final String insertContentAction = "insert-content";
    public static final String insertBreakAction = "insert-break";
    public static final String insertTabAction = "insert-tab";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String deleteNextCharAction = "delete-next";
    public static final String readOnlyAction = "set-read-only";
    public static final String writableAction = "set-writable";
    public static final String cutAction = "cut-to-clipboard";
    public static final String copyAction = "copy-to-clipboard";
    public static final String pasteAction = "paste-from-clipboard";
    public static final String beepAction = "beep";
    public static final String pageUpAction = "page-up";
    public static final String pageDownAction = "page-down";
    static final String selectionPageUpAction = "selection-page-up";
    static final String selectionPageDownAction = "selection-page-down";
    public static final String forwardAction = "caret-forward";
    public static final String backwardAction = "caret-backward";
    public static final String selectionForwardAction = "selection-forward";
    public static final String selectionBackwardAction = "selection-backward";
    public static final String upAction = "caret-up";
    public static final String downAction = "caret-down";
    public static final String selectionUpAction = "selection-up";
    public static final String selectionDownAction = "selection-down";
    public static final String beginWordAction = "caret-begin-word";
    public static final String endWordAction = "caret-end-word";
    public static final String selectionBeginWordAction = "selection-begin-word";
    public static final String selectionEndWordAction = "selection-end-word";
    public static final String previousWordAction = "caret-previous-word";
    public static final String nextWordAction = "caret-next-word";
    public static final String selectionPreviousWordAction = "selection-previous-word";
    public static final String selectionNextWordAction = "selection-next-word";
    public static final String beginLineAction = "caret-begin-line";
    public static final String endLineAction = "caret-end-line";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String beginParagraphAction = "caret-begin-paragraph";
    public static final String endParagraphAction = "caret-end-paragraph";
    public static final String selectionBeginParagraphAction = "selection-begin-paragraph";
    public static final String selectionEndParagraphAction = "selection-end-paragraph";
    public static final String beginAction = "caret-begin";
    public static final String endAction = "caret-end";
    public static final String selectionBeginAction = "selection-begin";
    public static final String selectionEndAction = "selection-end";
    public static final String selectWordAction = "select-word";
    public static final String selectLineAction = "select-line";
    public static final String selectParagraphAction = "select-paragraph";
    public static final String selectAllAction = "select-all";
    static final String unselectAction = "unselect";
    public static final String defaultKeyTypedAction = "default-typed";
    private static final Action[] defaultActions = new Action[]{new InsertContentAction(), new DeletePrevCharAction(), new DeleteNextCharAction(), new ReadOnlyAction(), new WritableAction(), new CutAction(), new CopyAction(), new PasteAction(), new PageUpAction("page-up", false), new PageDownAction("page-down", false), new PageUpAction("selection-page-up", true), new PageDownAction("selection-page-down", true), new InsertBreakAction(), new BeepAction(), new NextVisualPositionAction("caret-forward", false, 3), new NextVisualPositionAction("caret-backward", false, 7), new NextVisualPositionAction("selection-forward", true, 3), new NextVisualPositionAction("selection-backward", true, 7), new NextVisualPositionAction("caret-up", false, 1), new NextVisualPositionAction("caret-down", false, 5), new NextVisualPositionAction("selection-up", true, 1), new NextVisualPositionAction("selection-down", true, 5), new BeginWordAction("caret-begin-word", false), new EndWordAction("caret-end-word", false), new BeginWordAction("selection-begin-word", true), new EndWordAction("selection-end-word", true), new PreviousWordAction("caret-previous-word", false), new NextWordAction("caret-next-word", false), new PreviousWordAction("selection-previous-word", true), new NextWordAction("selection-next-word", true), new BeginLineAction("caret-begin-line", false), new EndLineAction("caret-end-line", false), new BeginLineAction("selection-begin-line", true), new EndLineAction("selection-end-line", true), new BeginParagraphAction("caret-begin-paragraph", false), new EndParagraphAction("caret-end-paragraph", false), new BeginParagraphAction("selection-begin-paragraph", true), new EndParagraphAction("selection-end-paragraph", true), new BeginAction("caret-begin", false), new EndAction("caret-end", false), new BeginAction("selection-begin", true), new EndAction("selection-end", true), new DefaultKeyTypedAction(), new InsertTabAction(), new SelectWordAction(), new SelectLineAction(), new SelectParagraphAction(), new SelectAllAction(), new UnselectAction(), new DumpModelAction()};

    public Object clone() {
        return new DefaultEditorKit();
    }

    public Caret createCaret() {
        return null;
    }

    public Document createDefaultDocument() {
        return new PlainDocument();
    }

    public Action[] getActions() {
        return defaultActions;
    }

    public String getContentType() {
        return "text/plain";
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public void read(InputStream inputStream, Document document, int n) throws IOException, BadLocationException {
        this.read(new InputStreamReader(inputStream), document, n);
    }

    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        int n2;
        char[] cArray = new char[4096];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = document.getLength() == 0;
        while ((n2 = reader.read(cArray, 0, cArray.length)) != -1) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                switch (cArray[n4]) {
                    case '\r': {
                        if (bl) {
                            bl3 = true;
                            if (n4 == 0) {
                                document.insertString(n, "\n", null);
                                ++n;
                                break;
                            }
                            cArray[n4 - 1] = 10;
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case '\n': {
                        if (!bl) break;
                        if (n4 > n3 + 1) {
                            document.insertString(n, new String(cArray, n3, n4 - n3 - 1), null);
                            n += n4 - n3 - 1;
                        }
                        bl = false;
                        n3 = n4;
                        bl2 = true;
                        break;
                    }
                    default: {
                        if (!bl) break;
                        bl3 = true;
                        if (n4 == 0) {
                            document.insertString(n, "\n", null);
                            ++n;
                        } else {
                            cArray[n4 - 1] = 10;
                        }
                        bl = false;
                        break;
                    }
                }
                ++n4;
            }
            if (n3 >= n2) continue;
            if (bl) {
                if (n3 >= n2 - 1) continue;
                document.insertString(n, new String(cArray, n3, n2 - n3 - 1), null);
                n += n2 - n3 - 1;
                continue;
            }
            document.insertString(n, new String(cArray, n3, n2 - n3), null);
            n += n2 - n3;
        }
        if (bl) {
            document.insertString(n, "\n", null);
            bl3 = true;
        }
        if (bl4) {
            if (bl2) {
                document.putProperty(EndOfLineStringProperty, "\r\n");
            } else if (bl3) {
                document.putProperty(EndOfLineStringProperty, "\r");
            } else {
                document.putProperty(EndOfLineStringProperty, "\n");
            }
        }
    }

    public void write(OutputStream outputStream, Document document, int n, int n2) throws IOException, BadLocationException {
        this.write(new OutputStreamWriter(outputStream), document, n, n2);
    }

    /*
     * Unable to fully structure code
     */
    public void write(Writer var1_1, Document var2_2, int var3_3, int var4_4) throws IOException, BadLocationException {
        block10: {
            if (var3_3 < 0 || var3_3 + var4_4 > var2_2.getLength()) {
                throw new BadLocationException("DefaultEditorKit.write", var3_3);
            }
            var5_5 = new Segment();
            var6_6 = var4_4;
            var7_7 = var3_3;
            var8_8 = var2_2.getProperty("__EndOfLine__");
            if (var8_8 == null) {
                try {
                    var8_8 = System.getProperty("line.separator");
                }
                catch (SecurityException v0) {}
            }
            var9_9 = var8_8 instanceof String != false ? (String)var8_8 : null;
            if (var8_8 == null || var9_9.equals("\n")) ** GOTO lbl40
            while (var6_6 > 0) {
                var10_10 = Math.min(var6_6, 4096);
                var2_2.getText(var7_7, var10_10, var5_5);
                var11_12 = var5_5.offset;
                var12_13 = var5_5.array;
                var13_14 = var11_12 + var5_5.count;
                var14_15 = var11_12;
                while (var14_15 < var13_14) {
                    if (var12_13[var14_15] == '\n') {
                        if (var14_15 > var11_12) {
                            var1_1.write(var12_13, var11_12, var14_15 - var11_12);
                        }
                        var1_1.write(var9_9);
                        var11_12 = var14_15 + 1;
                    }
                    ++var14_15;
                }
                if (var13_14 > var11_12) {
                    var1_1.write(var12_13, var11_12, var13_14 - var11_12);
                }
                var7_7 += var10_10;
                var6_6 -= var10_10;
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                var10_11 = Math.min(var6_6, 4096);
                var2_2.getText(var7_7, var10_11, var5_5);
                var1_1.write(var5_5.array, var5_5.offset, var5_5.count);
                var7_7 += var10_11;
                var6_6 -= var10_11;
lbl40:
                // 2 sources

                ** while (var6_6 > 0)
            }
        }
        var1_1.flush();
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        public DefaultKeyTypedAction() {
            super(DefaultEditorKit.defaultKeyTypedAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null) {
                char c;
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                String string = actionEvent.getActionCommand();
                int n = actionEvent.getModifiers();
                if (string != null && string.length() > 0 && (n & 8) == 0 && (c = string.charAt(0)) >= ' ' && c != '\u007f') {
                    jTextComponent.replaceSelection(string);
                }
            }
        }
    }

    public static class InsertContentAction
    extends TextAction {
        public InsertContentAction() {
            super(DefaultEditorKit.insertContentAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                String string = actionEvent.getActionCommand();
                if (string != null) {
                    jTextComponent.replaceSelection(string);
                } else {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class InsertBreakAction
    extends TextAction {
        public InsertBreakAction() {
            super(DefaultEditorKit.insertBreakAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                jTextComponent.replaceSelection("\n");
            }
        }
    }

    public static class InsertTabAction
    extends TextAction {
        public InsertTabAction() {
            super(DefaultEditorKit.insertTabAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                jTextComponent.replaceSelection("\t");
            }
        }
    }

    static class DeletePrevCharAction
    extends TextAction {
        DeletePrevCharAction() {
            super(DefaultEditorKit.deletePrevCharAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            boolean bl = true;
            if (jTextComponent != null && jTextComponent.isEditable()) {
                try {
                    Document document = jTextComponent.getDocument();
                    Caret caret = jTextComponent.getCaret();
                    int n = caret.getDot();
                    int n2 = caret.getMark();
                    if (n != n2) {
                        document.remove(Math.min(n, n2), Math.abs(n - n2));
                        bl = false;
                    } else if (n > 0) {
                        document.remove(n - 1, 1);
                        bl = false;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            if (bl) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    static class DeleteNextCharAction
    extends TextAction {
        DeleteNextCharAction() {
            super(DefaultEditorKit.deleteNextCharAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            boolean bl = true;
            if (jTextComponent != null && jTextComponent.isEditable()) {
                try {
                    Document document = jTextComponent.getDocument();
                    Caret caret = jTextComponent.getCaret();
                    int n = caret.getDot();
                    int n2 = caret.getMark();
                    if (n != n2) {
                        document.remove(Math.min(n, n2), Math.abs(n - n2));
                        bl = false;
                    } else if (n < document.getLength()) {
                        document.remove(n, 1);
                        bl = false;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            if (bl) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    static class ReadOnlyAction
    extends TextAction {
        ReadOnlyAction() {
            super(DefaultEditorKit.readOnlyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.setEditable(false);
            }
        }
    }

    static class WritableAction
    extends TextAction {
        WritableAction() {
            super(DefaultEditorKit.writableAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.setEditable(true);
            }
        }
    }

    public static class CutAction
    extends TextAction {
        public CutAction() {
            super(DefaultEditorKit.cutAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.cut();
            }
        }
    }

    public static class CopyAction
    extends TextAction {
        public CopyAction() {
            super(DefaultEditorKit.copyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.copy();
            }
        }
    }

    public static class PasteAction
    extends TextAction {
        public PasteAction() {
            super(DefaultEditorKit.pasteAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.paste();
            }
        }
    }

    public static class BeepAction
    extends TextAction {
        public BeepAction() {
            super(DefaultEditorKit.beepAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    static class PageUpAction
    extends TextAction {
        private boolean select;

        public PageUpAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block6: {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent == null) break block6;
                Rectangle rectangle = new Rectangle();
                jTextComponent.computeVisibleRect(rectangle);
                int n = rectangle.y;
                rectangle.y -= rectangle.height;
                if (rectangle.y < 0) {
                    rectangle.y = 0;
                }
                n -= rectangle.y;
                jTextComponent.scrollRectToVisible(rectangle);
                int n2 = jTextComponent.getCaretPosition();
                try {
                    if (n2 == -1) break block6;
                    Rectangle rectangle2 = jTextComponent.modelToView(n2);
                    rectangle2.y -= n;
                    n2 = jTextComponent.viewToModel(new Point(rectangle2.x, rectangle2.y));
                    Document document = jTextComponent.getDocument();
                    if (n2 != 0 && n2 > document.getLength() - 1) {
                        n2 = document.getLength() - 1;
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                        break block6;
                    }
                    jTextComponent.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    static class PageDownAction
    extends TextAction {
        private boolean select;

        PageDownAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block6: {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent == null) break block6;
                Rectangle rectangle = new Rectangle();
                jTextComponent.computeVisibleRect(rectangle);
                int n = rectangle.y;
                rectangle.y += rectangle.height;
                if (rectangle.y + rectangle.height > jTextComponent.getHeight()) {
                    rectangle.y = jTextComponent.getHeight() - rectangle.height;
                }
                n = rectangle.y - n;
                jTextComponent.scrollRectToVisible(rectangle);
                int n2 = jTextComponent.getCaretPosition();
                try {
                    if (n2 == -1) break block6;
                    Rectangle rectangle2 = jTextComponent.modelToView(n2);
                    rectangle2.y += n;
                    n2 = jTextComponent.viewToModel(new Point(rectangle2.x, rectangle2.y));
                    Document document = jTextComponent.getDocument();
                    if (n2 != 0 && n2 > document.getLength() - 1) {
                        n2 = document.getLength() - 1;
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                        break block6;
                    }
                    jTextComponent.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    static class DumpModelAction
    extends TextAction {
        DumpModelAction() {
            super("dump-model");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Document document;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && (document = jTextComponent.getDocument()) instanceof AbstractDocument) {
                ((AbstractDocument)document).dump(System.err);
            }
        }
    }

    static class NextVisualPositionAction
    extends TextAction {
        private boolean select;
        private int direction;

        NextVisualPositionAction(String string, boolean bl, int n) {
            super(string);
            this.select = bl;
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block11: {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent == null) break block11;
                Caret caret = jTextComponent.getCaret();
                DefaultCaret defaultCaret = caret instanceof DefaultCaret ? (DefaultCaret)caret : null;
                int n = caret.getDot();
                Position.Bias[] biasArray = new Position.Bias[1];
                try {
                    Point point;
                    if (caret != null && (this.direction == 1 || this.direction == 5) && (point = caret.getMagicCaretPosition()) == null) {
                        Rectangle rectangle = defaultCaret != null ? jTextComponent.getUI().modelToView(jTextComponent, n, defaultCaret.getDotBias()) : jTextComponent.modelToView(n);
                        point = new Point(rectangle.x, rectangle.y);
                        caret.setMagicCaretPosition(point);
                    }
                    n = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n, defaultCaret != null ? defaultCaret.getDotBias() : Position.Bias.Forward, this.direction, biasArray);
                    if (biasArray[0] == null) {
                        biasArray[0] = Position.Bias.Forward;
                    }
                    if (defaultCaret != null) {
                        if (this.select) {
                            defaultCaret.moveDot(n, biasArray[0]);
                        } else {
                            defaultCaret.setDot(n, biasArray[0]);
                        }
                    } else if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                    if (this.direction == 3 || this.direction == 7) {
                        jTextComponent.getCaret().setMagicCaretPosition(null);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    static class BeginWordAction
    extends TextAction {
        private boolean select;

        BeginWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent == null) break block3;
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getWordStart(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                        break block3;
                    }
                    jTextComponent.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    static class EndWordAction
    extends TextAction {
        private boolean select;

        EndWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent == null) break block3;
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getWordEnd(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                        break block3;
                    }
                    jTextComponent.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    static class PreviousWordAction
    extends TextAction {
        private boolean select;

        PreviousWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent == null) break block3;
                try {
                    int n = jTextComponent.getCaretPosition();
                    n = Utilities.getPreviousWord(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                        break block3;
                    }
                    jTextComponent.setCaretPosition(n);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    static class NextWordAction
    extends TextAction {
        private boolean select;

        NextWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent == null) break block3;
                try {
                    int n = jTextComponent.getCaretPosition();
                    n = Utilities.getNextWord(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                        break block3;
                    }
                    jTextComponent.setCaretPosition(n);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    static class BeginLineAction
    extends TextAction {
        private boolean select;

        BeginLineAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent == null) break block4;
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getRowStart(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                    jTextComponent.getCaret().setMagicCaretPosition(null);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    static class EndLineAction
    extends TextAction {
        private boolean select;

        EndLineAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent == null) break block4;
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getRowEnd(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                    jTextComponent.getCaret().setMagicCaretPosition(null);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    static class BeginParagraphAction
    extends TextAction {
        private boolean select;

        BeginParagraphAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                Element element = Utilities.getParagraphElement(jTextComponent, n);
                n = element.getStartOffset();
                if (this.select) {
                    jTextComponent.moveCaretPosition(n);
                } else {
                    jTextComponent.setCaretPosition(n);
                }
            }
        }
    }

    static class EndParagraphAction
    extends TextAction {
        private boolean select;

        EndParagraphAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                Element element = Utilities.getParagraphElement(jTextComponent, n);
                n = element.getEndOffset();
                if (this.select) {
                    jTextComponent.moveCaretPosition(n);
                } else {
                    jTextComponent.setCaretPosition(n);
                }
            }
        }
    }

    static class BeginAction
    extends TextAction {
        private boolean select;

        BeginAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                if (this.select) {
                    jTextComponent.moveCaretPosition(0);
                } else {
                    jTextComponent.setCaretPosition(0);
                }
            }
        }
    }

    static class EndAction
    extends TextAction {
        private boolean select;

        EndAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                int n = document.getLength();
                if (this.select) {
                    jTextComponent.moveCaretPosition(n);
                } else {
                    jTextComponent.setCaretPosition(n);
                }
            }
        }
    }

    static class SelectWordAction
    extends TextAction {
        private Action start = new BeginWordAction("pigdog", false);
        private Action end = new EndWordAction("pigdog", true);

        SelectWordAction() {
            super(DefaultEditorKit.selectWordAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class SelectLineAction
    extends TextAction {
        private Action start = new BeginLineAction("pigdog", false);
        private Action end = new EndLineAction("pigdog", true);

        SelectLineAction() {
            super(DefaultEditorKit.selectLineAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class SelectParagraphAction
    extends TextAction {
        private Action start = new BeginParagraphAction("pigdog", false);
        private Action end = new EndParagraphAction("pigdog", true);

        SelectParagraphAction() {
            super(DefaultEditorKit.selectParagraphAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class SelectAllAction
    extends TextAction {
        SelectAllAction() {
            super(DefaultEditorKit.selectAllAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                jTextComponent.setCaretPosition(0);
                jTextComponent.moveCaretPosition(document.getLength());
            }
        }
    }

    static class UnselectAction
    extends TextAction {
        UnselectAction() {
            super(DefaultEditorKit.unselectAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.setCaretPosition(jTextComponent.getCaretPosition());
            }
        }
    }
}

