/*Data Access Library. v. 1.1.
 *Persistent object data id. 
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data;
import java.beans.*;


/**This abstract class represents a data id notion. It helps to search
 *individual PersistentObject(s) effectively.
 *@see PersistentObject
 *@author Alexander Jaremenko  <address><a href="mailto:jarem@altavista.net">&lt jarem@altavista.net &gt</a></address>
 */
public abstract class PODataId implements Cloneable , java.io.Serializable , DataAccessObject {
    private boolean _isModified;
    private DatastoreJDBC _objDS;

    protected transient DAPropertySupport _changes;
    protected transient boolean _sendingAttributeEvents;

    public PODataId() {
	_changes = new DAPropertySupport(this);
	_isModified = false;
    }

    public void setObjectsDatastore(DatastoreJDBC objD) {
	_objDS = objD;
    }

    public DatastoreJDBC getObjectsDatastore() {
	return _objDS;
    }
    
    public abstract Object clone();

    public void firePropertyChange(String prop, Object oldV, Object newV) {
	_changes.firePropertyChange(prop,oldV,newV);
    }

    public boolean isModified() {
	return _isModified;
    }

    public void propertyChange(PropertyChangeEvent ev) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
	_changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
	_changes.removePropertyChangeListener(l);
    }

    public void setModified(boolean flag) {
	_isModified = flag;
    }

    public String toString() {
	return toString(".");
    }

    public abstract String toString(String delim);

    protected boolean _isSendingAttributeEvents() {
	return _sendingAttributeEvents;
    }

    protected void _setSendingAttributeEvents(boolean flag) {
	_sendingAttributeEvents = flag;
    }

    public abstract Object getAttributes()[];

    public abstract String getAttributeStrings()[];

}
