/*
 * Decompiled with CFR 0.152.
 */
import com.glasskeylabs.gubcast.Gubcaster;
import com.glasskeylabs.gubcast.Gubclient;
import com.glasskeylabs.gubcast.Gubregistry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Gubd {
    private static Hashtable clients;
    private static Gubdregistry registry;
    private static Gubcaster gub;
    private static Socket shell;
    private static DataInputStream instream;
    private static DataOutputStream outstream;

    public static void main(String[] args) {
        int clientPortNbr = 4567;
        int shellPortNbr = 5108;
        ServerSocket dialup = null;
        InetAddress host = null;
        int portNbr = -1;
        try {
            clients = new Hashtable();
            registry = new Gubdregistry(clients);
            gub = new Gubcaster(clientPortNbr, (Gubregistry)registry);
            dialup = new ServerSocket(shellPortNbr, 50);
        }
        catch (Exception x1) {
            System.out.println("Exception constructing Gubcaster: " + x1.getMessage());
            System.exit(-1);
        }
        while (true) {
            try {
                shell = dialup.accept();
                instream = new DataInputStream(shell.getInputStream());
                outstream = new DataOutputStream(shell.getOutputStream());
                registry.attachShell(shell, instream, outstream);
                Enumeration clientList = clients.elements();
                while (clientList.hasMoreElements()) {
                    registry.forwardClientState((Gubclient)clientList.nextElement(), true);
                }
                clientList = null;
            }
            catch (Exception x1) {
                System.out.println("Exception on accept(): " + x1.getMessage());
                break;
            }
            while (true) {
                try {
                    String urlText;
                    String targetName;
                    byte[] stringBuffer;
                    int stringLength;
                    Gubclient client;
                    do {
                        if ((stringLength = instream.readInt()) == 0) {
                            host = null;
                            continue;
                        }
                        stringBuffer = new byte[stringLength];
                        instream.readFully(stringBuffer);
                        String addressName = new String(stringBuffer);
                        host = InetAddress.getByName(addressName);
                    } while ((client = (Gubclient)clients.get(Gubclient.composeID(host, (int)(portNbr = instream.readInt())))) == null);
                    stringLength = instream.readInt();
                    if (stringLength == 0) {
                        targetName = null;
                    } else {
                        stringBuffer = new byte[stringLength];
                        instream.readFully(stringBuffer);
                        targetName = new String(stringBuffer);
                    }
                    stringLength = instream.readInt();
                    if (stringLength == 0) {
                        urlText = null;
                    } else {
                        stringBuffer = new byte[stringLength];
                        instream.readFully(stringBuffer);
                        urlText = new String(stringBuffer);
                    }
                    if (targetName == null || urlText == null) continue;
                    try {
                        gub.pushPage(client, targetName, urlText);
                    }
                    catch (SocketException x1) {
                        registry.unregisterClient(host, portNbr);
                    }
                }
                catch (EOFException x1) {
                    break;
                }
                catch (SocketException x2) {
                    break;
                }
                catch (Exception x3) {
                    System.out.println("Unknown Gubd failure: " + x3.getMessage());
                    x3.printStackTrace();
                    break;
                }
            }
            registry.detachShell();
            try {
                shell.close();
            }
            catch (Exception x1) {
                // empty catch block
            }
            shell = null;
            instream = null;
            outstream = null;
        }
        try {
            dialup.close();
        }
        catch (Exception x1) {
            // empty catch block
        }
    }
}

