
import java.awt.*;
import java.io.*;
import java.net.*;


				/**
   * This is concrete implementation of the PipeFilter interface.
   * It uses the GrepReader we defined elsewhere to do the filtering.
   **/
  public class GrepFilter extends PipeFilter {
	protected String pattern;  // The string to grep for.

  
	/** 
	 * Create a GrepFilter, will search its input for the specified pattern
	 * and send the results to the specified Pipe.
	 **/
	public GrepFilter(Pipe sink, String pattern) 
		 throws IOException { 
	  super(sink);
	  this.pattern = pattern; 
	}
	/** 
	 * Do the filtering, using a GrepReader to filter lines read from
	 * the Reader, and using a PrintWriter to send those lines back out
	 * to the Writer.
	 **/
	public void filter(Reader in, Writer out) throws IOException {
	  GrepReader gr = new GrepReader(new BufferedReader(in), pattern);
	  PrintWriter pw = new PrintWriter(out);
	  String line;
	 
	  while((line = gr.readLine()) != null) pw.println(line);
	 
	}
}            