/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import symantec.itools.awt.Slider;
import symantec.itools.awt.SliderTick;
import symantec.itools.awt.VerticalSliderThumb;
import symantec.itools.awt.VerticalSliderThumbBoth;
import symantec.itools.awt.VerticalSliderThumbLeft;
import symantec.itools.awt.VerticalSliderThumbRight;

public class VerticalSlider
extends Slider {
    protected static final int TICK_WIDTH = 4;
    protected String actionCommand = "VSliderMoved";
    private VerticalSliderThumb thumb = new VerticalSliderThumbBoth();
    private Mouse mouse;
    private MouseMtn mouseMotion;

    public VerticalSlider() {
        this.width = 175;
    }

    public void setTickStyle(int style) throws PropertyVetoException {
        if (this.style != style) {
            super.setTickStyle(style);
            switch (style) {
                case 0: {
                    this.thumb = new VerticalSliderThumbLeft();
                    break;
                }
                case 1: {
                    this.thumb = new VerticalSliderThumbRight();
                    break;
                }
                default: {
                    this.thumb = new VerticalSliderThumbBoth();
                }
            }
            this.repaint();
        }
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMtn();
            this.addMouseMotionListener(this.mouseMotion);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        super.removeNotify();
    }

    protected void do_reshape(int w, int h) {
        float hb = 15.0f;
        float vb = 10.0f;
        if ((float)w < hb) {
            hb = w / 4;
        }
        if ((float)h < vb) {
            vb = h / 4;
        }
        float x0 = hb;
        float x1 = (float)w - hb;
        float y0 = vb;
        float y1 = (float)h - vb;
        if (x0 == 0.0f) {
            x0 = 1.0f;
        }
        if (x1 == 0.0f) {
            x1 = 1.0f;
        }
        if (y0 == 0.0f) {
            y0 = 1.0f;
        }
        if (y1 == 0.0f) {
            y1 = 1.0f;
        }
        float n = (this.max - this.min) / this.freq + 1;
        this.tick = new SliderTick[(int)n];
        float vs = (y1 - y0) / (n - 1.0f);
        int i = 0;
        while ((float)i < n) {
            float ch = (float)i * vs;
            this.tick[i] = new SliderTick((int)x0, (int)x1, (int)(y0 + ch), (int)ch);
            ++i;
        }
        this.thumb.resize((int)(x1 - x0 - 4.0f - 1.0f), (int)(vs / 2.0f));
    }

    public void paint(Graphics g) {
        SliderTick t;
        super.paint(g);
        if (this.tick.length == 0) {
            return;
        }
        this.thumb.draw(g, this.tick[this.curPos]);
        if (this.prevPos != this.curPos) {
            this.thumb.clip(g, this.tick[this.prevPos]);
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.black);
        int w = this.width - 1;
        int h = this.height - 1;
        if (this.showBorder) {
            g.drawRect(0, 0, w, h);
        }
        int i = 0;
        while (i < this.tick.length) {
            boolean end = i == 0 || i == this.tick.length - 1;
            t = this.tick[i];
            if (this.style == 0 || this.style == 2) {
                g.drawLine(t.a + (end ? 0 : 1), t.c, t.a + 4, t.c);
            }
            if (this.style == 1 || this.style == 2) {
                g.drawLine(t.b - 4, t.c, t.b - (end ? 0 : 1), t.c);
            }
            ++i;
        }
        t = this.tick[0];
        int x = (t.b + t.a) / 2;
        int y0 = t.c - 5;
        int y1 = this.tick[this.tick.length - 1].c + 5;
        g.drawLine(x, y0, x, y1);
        g.setColor(Color.gray);
        g.drawLine(x - 1, y1 + 1, x - 1, y0 - 1);
        g.drawLine(x - 1, y0 - 1, x + 1, y0 - 1);
        g.setColor(Color.lightGray);
        g.drawLine(x + 1, y0, x + 1, y1 + 1);
        g.drawLine(x + 1, y1 + 1, x, y1 + 1);
        g.setColor(Color.white);
        g.drawLine(x + 2, y0 - 1, x + 2, y1 + 2);
        g.drawLine(x + 2, y1 + 2, x - 1, y1 + 2);
        g.clipRect(0, 0, this.width, this.height);
        this.thumb.draw(g, this.tick[this.curPos]);
        this.prevPos = this.curPos;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.do_reshape(this.width, this.height);
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent e) {
            VerticalSlider.this.moveThumb(e.getY(), true);
        }

        Mouse() {
            VerticalSlider.this = VerticalSlider.this;
        }
    }

    class MouseMtn
    extends MouseMotionAdapter
    implements Serializable {
        public void mouseDragged(MouseEvent e) {
            VerticalSlider.this.moveThumb(e.getY(), false);
        }

        MouseMtn() {
            VerticalSlider.this = VerticalSlider.this;
        }
    }
}

