package cern.lhcias.csgui.interfaces;

import java.io.*;
import java.awt.*;
import java.util.*;
import cern.lhcias.csgui.Events.*;
import cern.lhcias.csgui.Services.*;

/**
*<br> This interface defines a component used to visualize in some means the behaviour of the
*<br> tags. Typical implementations of this interface could be graphical trending system, 
*<br> alarm display windows, control system's supervisory synoptics, the representation of a led,
*<br> the representation of a dial, ....
*<br> A TagsView must be an awt component of some sort (such as a canvas or a panel) to be 
*<br> able to be inserted in windows or other components. Some TagsViews may then be containers
*<br> for other TagsViews.
*<br> 
*<br> VIEW TYPE:
*<br> Each TagsView implements one or several "view types", which is a name describing 
*<br> the represention. Using the methods getType(), getPossibleTypes() and 
*<br> doYouImplement(String type)the system can dynamically make the correspondance 
*<br> between a representation asked by a user and the component class which offers 
*<br> this kind of representation. 
*<br> This "view type" can be different from the class' name enabling a single class to 
*<br> offers different view types.
*<br> If the system doesn't find a preloaded class implementing the required view type, it will
*<br> try to dynamically find and load a class which name is equal to the view type.
*<br> 
*<br> CONFIGURATION:
*<br> To enable serialization and to easily configure the TagsView, each of them must be implements
*<br> the methods toString() and setConfig(String config). By doing so, TagsViews don't have to
*<br> bother about saving or loading their configuration. This will be handled by the system 
*<br> (see configurationMgr).
*<br> 
*<br> EVENTS:
*<br> It is assumed that the TagsView sends the TagClickedEvent when the operator clicks on the
*<br> representation of a Tag, enabling so a uniform and easy behaviour of the interface.
*/
public interface TagsView extends TagChangeListener { // Must be a component of some sort
    /**
    To be called once after instantiating the class.
    */
	void	instantiate(TagArrays TA, String configname, 
	                    TagChangeAdapter adapter, 
	                    TagClickedAdapter cadapter,
	                    OpenViewAdapter opadapter,
	                    configurationMgr cM,
	                    AlarmAdapter aA);
    void      removeNotify();
	void      setBounds(int x, int y, int width, int height);
    Rectangle getBounds();
    Dimension getPreferredSize();
    void      repaint();

    /** returns the configuration of the TagsView as a String.
    */
	String  toString();
    /** configure the TagsView with a String
    */
	void	setConfig(String config);

    /** adds the tag named tagName to the list of Tags shown in
    this TagsView.
    */
    void    addTag(String tagName);
    /** adds the list of tags which names are in tagNames  to the list of Tags shown in
    this TagsView.
    */
    void    addTag(Vector tagNames);
    /** adds the TagsView TVcomponent or all the tags shown in TVcomponent to the list 
    of Tags shown in this TagsView.
    */
    void    addTag(TagsView TVcomponent);
    /** removes the tag named tagName from the list of Tags shown in
    this TagsView.
    */
    void    removeTag(String tagName);
    /** removes the list of tags which names are in tagNames  from the list of Tags shown in
    this TagsView.
    */
    void    removeTag(Vector tagNames);
    /** removes the TagsView TVcomponent or all the tags shown in TVcomponent from the 
    list of Tags shown in this TagsView.
    */
    void    removeTag(TagsView TVcomponent);

    void    setProperty(String tagName, String tagProperty, String propertyValue);

    void    addTagClickedListener( TagClickedListener listener);
    void    removeTagClickedListener(TagClickedListener listener);
    void    addOpenViewListener( OpenViewListener listener);
    void    removeOpenViewListener(OpenViewListener listener);
	void    addMouseListener(java.awt.event.MouseListener cMouse);
    void    addAlarmListener(AlarmListener listener);
    void    removeAlarmListener(AlarmListener listener);
    
    /** returns the number of components (TagsViews), if any, included as subcomponents
    of this TagsView. Just one level. Not recursive
    */
	int     getComponentNb(); 
    /** returns the list of components (TagsViews), if any, included as subcomponents
    of this TagsView. Just one level. Not recursive
    */
    Vector  getComponentsList(); 
    /** returns the names of all the tags, recursively, shown in this TagsView. 
    */
    Vector  getTagNames(); 
    /** returns the names of all the tags shown directly in this TagsView, but not shown in 
    subcompoennts. 
    */
    Vector  getLocalTagNames(); 
    
    /** returns the current implemented "view type"
    */
    String  getType();
    /** returns the list of possible "view types" (or representations) offered by this
    TagsView.
    */
    Vector  getPossibleTypes();
    /** returns true if this TagsView offers the "view type" type.
    */
	boolean doYouImplement(String type);
}

