package tester;

/**
 * @(#)Grade.java	03/19/02
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 */
import java.text.DateFormat;
import java.text.ParseException;
import java.util.*;
import java.io.*;
import java.net.*;

/**
 * Grade is the object that calculates and returns the test grade.
 * It also updates a log file with all taken tests.
 *
 * @author Panagiotis Plevrakis
 *
 * Email: pplevrakis@hotmail.com
 * URL:   http://www30.brinkster.com/panos69/JProjects.aspx
 */
public class Grade {

	protected static int c = 0;
	private Calendar calendar;
	private Date now;
	private DateFormat localFormat;
	private TestLoader load;
	protected static List listWrong;
	private StringBuffer bf;
	private RandomAccessFile fr;
	private Answers ans;
	private BufferedReader buf;

    /**
     * Creates a new Grade object.
     */
	public Grade() {
	listWrong = new ArrayList();
	load = new TestLoader();
	calendar = new GregorianCalendar();
	now = calendar.getTime();
	localFormat = DateFormat.getDateInstance();
	bf = new StringBuffer();
	ans = new Answers();
	}

    /**
	 * Compares the user's answers with the answer key
	 * and calculates the grade.
     */
	public void calculateGrade() {
	int i=0;
		while (i < ans.getAnswerKeyLength()) {
			if (ans.getUserAnswer(i).equalsIgnoreCase(ans.getCorrectAnswer(i))) {
				c++;
			}
			else {
				collectWrong("" + (i+1));
	    	}
	i++;
	}
	}

    /**
	 * Returns the number of correct answers.
     */
	public int getCorrect() {
		return c;
	}

    /**
	 * Returns the score as a percentage.
     */
	public int getScore() {
		return getCorrect() * 100 / load.files.length;
	}

    /**
	 * Creates and returns a summary list of all incorrectly
	 * answered questions and their correct answers.
     */
	public String getWrong() {
	StringBuffer bf = new StringBuffer();
	Iterator it = listWrong.iterator();
		while (it.hasNext()) {
			String s = (String)it.next();
			if (s.length() == 1) {
    			bf.append("<P>   &nbsp;&nbsp;" + s + " was incorrect. The correct answer is : " +
    	          		   ans.getCorrectAnswer((Integer.parseInt(s))-1) + "</P>\n");
		    }
    		else {
    			bf.append("<P>   " + s + " was incorrect. The correct answer is : " +
                           ans.getCorrectAnswer((Integer.parseInt(s))-1) + "</P>\n");
		    }
	    }
    return bf.toString();
	}

    /* Stores in an ArrayList object the question number of each incorrectly
       answered question. It is called from calculateGrade */
	private void collectWrong(String wrong) {
		listWrong.add(wrong);
	}

    public URL getGradeData() {
    try {
    	BufferedWriter bw = new BufferedWriter(new FileWriter(load.path +
        File.separator + "grade.html"));
		bw.write("<HTML>\n<BODY>\n<P><B>\n" + getWrong() + "</B></P>\n" +
		         "<HR>\n<P><B>\n" + "		Your score is : " +
		         getScore() + " %\n</B></P>\n");
		bw.write("<P><B>		You answered " + getCorrect() + " of " +
		         load.files.length + "\n</B></P>\n</BODY>\n</HTML>");
    	bw.close();
		bw = null;
		System.gc();
	} catch (IOException e) {
    	System.out.println(e.getMessage());
    }
	URL grade = null;
	try {
    	grade = new URL("file:///" + load.path + File.separator + "grade.html");
		return grade;
	} catch (MalformedURLException ex) {
		System.out.println(ex.getMessage());
	}
	return grade;
	}
} //end class