package com.unipro.products.smgui;

import javax.swing.*;

/**
 * This class holds the 'Recipients' data for "Recipients combo-box".
 *
 * @author Alexey Skorokhodov
 * @version 1.0
 */
public class RecipientsComboBoxModel
    extends DefaultComboBoxModel {

    /**
     * Inserts the string to the beginning of the Data vector.
     * If such string already exists, it is moved to the beginning of the vector.
     * The new element is selected.
     *
     * @param recipient the string to add to the data vector.
     *        If this parameter is NULL, it is ignored.
     */
    public void addOrUpdateRecipient(String recipient) {
        if (recipient != null) {
            removeElement(recipient);
            insertElementAt(recipient, 0);
            setSelectedItem(recipient);
            fireContentsChanged(this, 0, getSize());
        }
    }
}