/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Vector;
import org.webmacro.engine.Engine;
import org.webmacro.engine.Macro;
import org.webmacro.engine.ParseException;
import org.webmacro.engine.ParseTool;
import org.webmacro.engine.Variable;
import org.webmacro.util.InvalidContextException;
import org.webmacro.util.Log;
import org.webmacro.util.java2.HashMap;

public final class ParsedString
extends Vector
implements Macro {
    private static final boolean debug = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object evaluate(Object object) throws InvalidContextException {
        StringBuffer stringBuffer = new StringBuffer(96);
        int n = 0;
        while (n < this.elementCount) {
            Object object2 = this.elementData[n];
            if (!(object2 instanceof Macro)) {
                stringBuffer.append(object2.toString());
            } else {
                try {
                    stringBuffer.append(((Variable)object2).evaluate(object));
                }
                catch (ClassCastException classCastException) {
                    throw new InvalidContextException("ParsedString: Expected variable or string, got: " + object2);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public final void write(Writer writer, Object object) throws InvalidContextException, IOException {
        writer.write(this.evaluate(object).toString());
    }

    public static final Object parse(ParseTool parseTool) throws ParseException, IOException {
        boolean bl = false;
        boolean bl2 = false;
        ParsedString parsedString = new ParsedString();
        bl2 = parseTool.parseChar('\'');
        if (bl2) {
            bl = true;
        } else if (parseTool.parseChar('\"')) {
            bl = true;
        } else {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(96);
        Object object = new Object();
        boolean bl3 = false;
        while (!bl3 && parseTool.ttype != -1 && parseTool.ttype != 10) {
            object = null;
            switch (parseTool.ttype) {
                case -3: {
                    stringBuffer.append(parseTool.sval);
                    break;
                }
                case 36: {
                    object = Variable.parse(parseTool);
                    if (object != null) break;
                    Engine.log.warning("ParsedString: Expected a variable got nothing");
                    stringBuffer.append("<!--\n expected variable got nothing \n-->");
                    break;
                }
                case 39: {
                    if (bl2) {
                        bl3 = true;
                        break;
                    }
                    stringBuffer.append((char)parseTool.ttype);
                    break;
                }
                case 34: {
                    if (!bl2 && bl) {
                        bl3 = true;
                        break;
                    }
                    stringBuffer.append((char)parseTool.ttype);
                    break;
                }
                default: {
                    stringBuffer.append((char)parseTool.ttype);
                    break;
                }
            }
            if (object != null) {
                parsedString.addElement(stringBuffer.toString());
                parsedString.addElement(object);
                stringBuffer.setLength(0);
                continue;
            }
            int n = parseTool.nextToken();
        }
        if (object == null && stringBuffer.length() > 0) {
            parsedString.addElement(stringBuffer.toString());
        }
        if (!bl3) {
            if (parseTool.ttype == -1) {
                throw new ParseException(parseTool, "expected close quote but got EOF");
            }
            throw new ParseException(parseTool, "expected close quote but got EOL");
        }
        return parsedString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] stringArray) {
        Log.setLevel(Log.DEBUG);
        Log.traceExceptions(true);
        try {
            HashMap hashMap = new HashMap();
            Integer n = new Integer(10);
            Integer n2 = new Integer(20);
            hashMap.put("a", n);
            hashMap.put("b", n2);
            StringReader stringReader = new StringReader("\"expect no variable at all\"");
            ParseTool parseTool = new ParseTool("string", stringReader);
            parseTool.nextToken();
            ParsedString parsedString = (ParsedString)ParsedString.parse(parseTool);
            System.out.println("expected string: /expect no variable at all/");
            System.out.println("evaluated string: " + parsedString.evaluate(hashMap));
            System.out.println("");
            StringReader stringReader2 = new StringReader("'single \"quote no variable'");
            ParseTool parseTool2 = new ParseTool("string", stringReader2);
            parseTool2.nextToken();
            ParsedString parsedString2 = (ParsedString)ParsedString.parse(parseTool2);
            System.out.println("expected string: /single \"quote no variable/");
            System.out.println("evaluated string: " + parsedString2.evaluate(hashMap));
            hashMap.put(parsedString2.toString(), parsedString2);
            System.out.println("");
            StringReader stringReader3 = new StringReader("\"$a ParsedString at beginning\"");
            ParseTool parseTool3 = new ParseTool("string", stringReader3);
            parseTool3.nextToken();
            ParsedString parsedString3 = (ParsedString)ParsedString.parse(parseTool3);
            System.out.println("expected string: /10 ParsedString at beginning/");
            System.out.println("evaluated string: " + parsedString3.evaluate(hashMap));
            System.out.println("");
            StringReader stringReader4 = new StringReader("''");
            ParseTool parseTool4 = new ParseTool("string", stringReader4);
            parseTool4.nextToken();
            ParsedString parsedString4 = (ParsedString)ParsedString.parse(parseTool4);
            System.out.println("expected string: //");
            System.out.println("evaluated string: " + parsedString4.evaluate(hashMap));
            System.out.println("");
            StringReader stringReader5 = new StringReader("'unfinished ParsedString at end $'");
            ParseTool parseTool5 = new ParseTool("string", stringReader5);
            parseTool5.nextToken();
            ParsedString parsedString5 = (ParsedString)ParsedString.parse(parseTool5);
            System.out.println("expected string: /unfinished ParseString at end <!--\n expected variable got nothing \n-->/");
            System.out.println("evaluated string: " + parsedString5.evaluate(hashMap));
            hashMap.put(parsedString5.toString(), parsedString5);
            System.out.println("");
            return;
        }
        catch (Exception exception) {
            System.out.println("MAIN CAUGHT AN EXCEPTION");
            exception.printStackTrace();
        }
    }

    ParsedString() {
    }
}

