/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util.java2;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.webmacro.util.java2.Map;

public class HashMap
implements Map {
    private Hashtable myMap = new Hashtable();
    private Vector myFriendMaps = new Vector();
    private Class myKeyType = null;
    private Class myValueType = null;

    public final void clear() {
        this.myMap.clear();
        this.myFriendMaps.removeAllElements();
    }

    public final boolean containsKey(Object object) {
        if (this.myMap.containsKey(object)) {
            return true;
        }
        Enumeration enumeration = this.myFriendMaps.elements();
        while (enumeration.hasMoreElements()) {
            Map map = (Map)enumeration.nextElement();
            if (!map.containsKey(object)) continue;
            return true;
        }
        return false;
    }

    public final Object get(Object object) {
        Object object2 = this.myMap.get(object);
        if (object2 != null) {
            return object2;
        }
        Enumeration enumeration = this.myFriendMaps.elements();
        while (enumeration.hasMoreElements()) {
            Map map = (Map)enumeration.nextElement();
            object2 = map.get(object);
            if (object2 == null) continue;
            return object2;
        }
        return null;
    }

    public final boolean isEmpty() {
        return this.myMap.isEmpty() && this.myFriendMaps.isEmpty();
    }

    public final Object put(Object object, Object object2) throws ClassCastException {
        if (object == null || object2 == null) {
            return null;
        }
        if (this.myKeyType != null && object != null && !this.myKeyType.isInstance(object)) {
            throw new ClassCastException("Map Class: unexpected key class");
        }
        if (this.myValueType != null && object2 != null && !this.myValueType.isInstance(object2)) {
            throw new ClassCastException("Map Class: unexpected value class");
        }
        return this.myMap.put(object, object2);
    }

    public final Object remove(Object object) {
        Object object2 = this.myMap.remove(object);
        Object var3_3 = null;
        var3_3 = object2;
        Enumeration enumeration = this.myFriendMaps.elements();
        while (enumeration.hasMoreElements()) {
            Map map = (Map)enumeration.nextElement();
            object2 = map.remove(object);
            if (object2 == null) continue;
            var3_3 = object2;
        }
        return var3_3;
    }

    public final void include(HashMap hashMap) throws ClassCastException {
        if (hashMap == this) {
            return;
        }
        if (this.myKeyType == null ? hashMap.myKeyType != null : !this.myKeyType.equals(hashMap.myKeyType)) {
            throw new ClassCastException("include(): expected same key class");
        }
        if (this.myValueType == null) {
            if (hashMap.myValueType != null) {
                throw new ClassCastException("include(): expected same key class");
            }
        } else if (!this.myValueType.equals(hashMap.myValueType)) {
            throw new ClassCastException("include(): expected same value class");
        }
        this.myFriendMaps.addElement(hashMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void exclude(HashMap hashMap) {
        try {
            if (!this.myFriendMaps.contains(hashMap)) return;
            this.myFriendMaps.removeElement(hashMap);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            Class<?> clazz = Class.forName("java.lang.String");
            Class<?> clazz2 = Class.forName("java.lang.Integer");
            Integer n = new Integer(20);
            Integer n2 = new Integer(10);
            Integer n3 = new Integer(15);
            Integer n4 = new Integer(30);
            Integer n5 = new Integer(200);
            Integer n6 = new Integer(2000);
            String string = new String("remove");
            String string2 = new String("delete string a");
            String string3 = new String("string a");
            String string4 = new String("string b");
            String string5 = new String("string c");
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            HashMap hashMap4 = new HashMap(clazz, clazz2);
            HashMap hashMap5 = new HashMap(clazz, clazz2);
            HashMap hashMap6 = new HashMap(clazz, clazz);
            HashMap hashMap7 = new HashMap(clazz2, clazz2);
            System.out.println("Test: new noClassMapA is empty");
            if (!hashMap.isEmpty()) {
                System.out.println("Err: new map class should be empty");
            } else {
                System.out.println("verified: new noClassMapA class is empty");
            }
            System.out.println("");
            System.out.println("Test: new ClassMappedB is empty");
            if (!hashMap5.isEmpty()) {
                System.out.println("Err: new map class should be empty");
            } else {
                System.out.println("verified: new ClassMappedB class is empty");
            }
            System.out.println("");
            hashMap.put(string, n);
            hashMap.put(string2, n2);
            hashMap.put(string3, n4);
            hashMap.put(null, null);
            System.out.println("Test: added <string a, 30> to noClassMapA");
            System.out.println("check: if <string a, 30> added");
            if (!hashMap.containsKey(string3)) {
                System.out.println("Err: added key not found in Map");
            } else {
                System.out.print("found <string a>: value is ");
                System.out.println(hashMap.get(string3));
            }
            System.out.println("");
            System.out.println("Test: Delete Method");
            System.out.println("check: if <remove, 10> added");
            if (!hashMap.containsKey(string2)) {
                System.out.println("Err: added key not found in Map");
            } else {
                System.out.print("found remove: value is ");
                System.out.println(hashMap.get(string2));
            }
            System.out.println("");
            System.out.println("deleting <delete string a, 10> added");
            System.out.println("does string exist");
            if (n2 != (Integer)hashMap.get(string2)) {
                System.out.println("Err: string does not exist");
            } else {
                System.out.println("String exists and is 10");
            }
            if (n2 != (Integer)hashMap.remove(string2)) {
                System.out.println("Err: key not properly deleted");
            }
            System.out.println("checking if <delete string a, 10> was deleted");
            if (hashMap.containsKey(string2)) {
                System.out.println("Err: deleted key should no appear in Map");
            } else {
                System.out.println("remove method behaved as expected.");
            }
            System.out.println("");
            hashMap2.put(null, null);
            hashMap2.put(string, n5);
            hashMap2.put(string4, n2);
            hashMap3.put(null, null);
            hashMap3.put(string, n6);
            hashMap3.put(string5, n3);
            hashMap.include(hashMap);
            hashMap.include(hashMap2);
            hashMap.include(hashMap3);
            System.out.println("Test: include method hashB and containsKey");
            if (!hashMap.containsKey(string4)) {
                System.out.println("Err: key in included map should appear");
            } else {
                System.out.print("included map key is found: (10) value is ");
                System.out.println(hashMap.get(string4));
            }
            System.out.println("");
            System.out.println("Test: include method hashC and containsKey");
            if (!hashMap.containsKey(string5)) {
                System.out.println("Err: key in included map should appear");
            } else {
                System.out.print("included map key is found: (15) value is ");
                System.out.println(hashMap.get(string5));
            }
            System.out.println("");
            System.out.println("Test: remove will remove from all myFriendMap");
            if (n6 != (Integer)hashMap.remove(string)) {
                System.out.println("Err: remove should first come from THIS map");
            } else {
                System.out.println("proper return object ie value = twoThousand");
            }
            System.out.println("make sure string has been properly removed");
            if (hashMap.containsKey(string)) {
                System.out.println("Err: key in included map should appear");
            } else {
                System.out.println("removed behave as expected with one list");
            }
            System.out.println("Make sure whole hashC has not been removed");
            if (!hashMap.containsKey(string5)) {
                System.out.println("Err: key in included map should appear");
            } else {
                System.out.print("included map key is found: (15) value is ");
                System.out.println(hashMap.get(string5));
            }
            System.out.println("");
            hashMap.exclude(hashMap2);
            System.out.println("Test: exclude method");
            System.out.println("HashB should be removed");
            if (hashMap.containsKey(string4)) {
                System.out.println("string b key should be removed by exclude");
            } else {
                System.out.println("proper behaviour string b key not found");
            }
            System.out.println("");
            System.out.println("HashC should not be removed");
            if (!hashMap.containsKey(string5)) {
                System.out.println("Err: strStringC should not be removed");
            } else {
                System.out.println("as expected string c key is still there");
            }
            System.out.println("");
            System.out.println("Test: put and include with the wrong classtypes");
            hashMap4.put(string3, n2);
            hashMap4.put(string, n);
            hashMap5.put(string4, n2);
            hashMap5.put(string, n5);
            try {
                hashMap5.put(n, n2);
            }
            catch (ClassCastException classCastException) {
                System.out.println("Got the expected exception putting wrong type.");
            }
            System.out.println("Testing proper classtype for put <remove, 20>");
            if (!hashMap5.containsKey(string)) {
                System.out.println("Err: strRemove should have been added");
            } else {
                System.out.println("Put behaved as Expected");
            }
            System.out.println("");
            System.out.println("Testing wrong classtype for put <20, 10>");
            if (hashMap5.containsKey(n)) {
                System.out.println("Err: twenty should not have been added");
            } else {
                System.out.println("Put behaved as Expected");
            }
            System.out.println("");
            try {
                hashMap6.put(n, n5);
            }
            catch (ClassCastException classCastException) {
                System.out.println("Got the expected exception putting wrong type.");
            }
            try {
                hashMap6.put(string, n6);
            }
            catch (ClassCastException classCastException) {
                System.out.println("Got the expected exception putting wrong type.");
            }
            hashMap6.put(string5, string5);
            System.out.println("Testing wrong classtype for put <20, 200>");
            if (hashMap6.containsKey(n)) {
                System.out.println("Err: twenty should not have been added");
            } else {
                System.out.println("Put behaved as Expected");
            }
            System.out.println("");
            System.out.println("Testing wrong classtype for put <remove, 2000>");
            if (hashMap6.containsKey(string)) {
                System.out.println("Err: remove should not have been added");
            } else {
                System.out.println("Put behaved as Expected");
            }
            System.out.println("");
            hashMap7.put(n2, n);
            System.out.println("Test: clear with multiple list");
            hashMap4.clear();
            System.out.println("Testing For string in A and B");
            if (hashMap4.containsKey(string3)) {
                System.out.println("string a should not exist");
            } else {
                System.out.println("clear behaved as Expected");
            }
            if (hashMap4.containsKey(string4)) {
                System.out.println("string B should not exist");
            } else {
                System.out.println("clear behaved as Expected");
            }
            if (hashMap4.containsKey(string)) {
                System.out.println("remove string should not exist");
            } else {
                System.out.println("clear behaved as Expected");
            }
            System.out.println("");
            return;
        }
        catch (ClassCastException classCastException) {
            System.out.println("FOUND CAST ERRORS");
            return;
        }
        catch (Exception exception) {
            System.out.println("MAIN CAUGHT AN EXCEPTION:");
            exception.printStackTrace();
        }
    }

    public HashMap() {
    }

    public HashMap(Class clazz, Class clazz2) {
        this.myKeyType = clazz;
        this.myValueType = clazz2;
    }
}

