/*
 *   @(#) MP3 Player 1.0 Demicron (demicron@demicron.com)
 *
 *   Java11Player.java   2002-09-17
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

import java.io.*;
import sun.audio.*;
import java.applet.*;

public class Java11Player {
  private InputStream is;
  private AudioStream as; // For java 1.1
  private bob64 b64;
  private boolean stopped;

  public Java11Player(InputStream is, bob64 b64) {
    this.is = is;
    this.b64 = b64;
  }

  public static void prepareAudioClip() {
    // Fr bort seghet vid frsta ljuduppspelning i IE...kanske gr att gra snabbare s inte exception kastas?
    try {
      AudioPlayer.player.stop((InputStream)null);
    } catch (Exception e) {}
  }

  public void play() {
    try {
      PipedOutputStream pos = new PipedOutputStream();
      PipedInputStream pis = new PipedInputStream(pos);
      for (int i=0; i<100; i++) {
        pos.write(is.read());
      }
      as = new AudioStream(pis);
      AudioPlayer.player.start(as);
      int aByte;
      while((aByte = is.read())!=-1) {
          if (b64.m.stop || stopped)
          //if (b64.m.a.rt==null || b64.playerThread!=Thread.currentThread())
            return;
          pos.write(aByte);
      }
      while (as.available()>0) {
        Thread.currentThread().sleep(10);
        if (b64.m.stop || stopped)
        //if (b64.m.a.rt==null || b64.playerThread!=Thread.currentThread())
          return;
      }
    } catch (Exception e) {e.printStackTrace();}
  }

  public void stop() {
    AudioPlayer.player.stop(as);
    stopped = true;
    as = null;
  }
}